/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.autocompletion;

import com.airhacks.afterburner.views.ViewLoader;
import com.dlsc.gemsfx.TagsField;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.autocompletion.AutoCompletionTabViewModel;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;

public class AutoCompletionTab
extends AbstractPreferenceTabView<AutoCompletionTabViewModel>
implements PreferencesTab {
    @FXML
    private CheckBox enableAutoComplete;
    @FXML
    private TagsField<Field> autoCompleteFields;
    @FXML
    private RadioButton autoCompleteFirstLast;
    @FXML
    private RadioButton autoCompleteLastFirst;
    @FXML
    private RadioButton autoCompleteBoth;
    @FXML
    private RadioButton firstNameModeAbbreviated;
    @FXML
    private RadioButton firstNameModeFull;
    @FXML
    private RadioButton firstNameModeBoth;

    public AutoCompletionTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Autocompletion", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new AutoCompletionTabViewModel(this.preferencesService.getAutoCompletePreferences());
        this.setupTagsFiled();
        this.enableAutoComplete.selectedProperty().bindBidirectional((Property)((AutoCompletionTabViewModel)this.viewModel).enableAutoCompleteProperty());
        this.autoCompleteFirstLast.selectedProperty().bindBidirectional((Property)((AutoCompletionTabViewModel)this.viewModel).autoCompleteFirstLastProperty());
        this.autoCompleteLastFirst.selectedProperty().bindBidirectional((Property)((AutoCompletionTabViewModel)this.viewModel).autoCompleteLastFirstProperty());
        this.autoCompleteBoth.selectedProperty().bindBidirectional((Property)((AutoCompletionTabViewModel)this.viewModel).autoCompleteBothProperty());
        this.firstNameModeAbbreviated.selectedProperty().bindBidirectional((Property)((AutoCompletionTabViewModel)this.viewModel).firstNameModeAbbreviatedProperty());
        this.firstNameModeFull.selectedProperty().bindBidirectional((Property)((AutoCompletionTabViewModel)this.viewModel).firstNameModeFullProperty());
        this.firstNameModeBoth.selectedProperty().bindBidirectional((Property)((AutoCompletionTabViewModel)this.viewModel).firstNameModeBothProperty());
    }

    private void setupTagsFiled() {
        this.autoCompleteFields.setCellFactory(new ViewModelListCellFactory().withText(Field::getDisplayName));
        this.autoCompleteFields.setSuggestionProvider(request -> ((AutoCompletionTabViewModel)this.viewModel).getSuggestions(request.getUserText()));
        this.autoCompleteFields.tagsProperty().bindBidirectional(((AutoCompletionTabViewModel)this.viewModel).autoCompleteFieldsProperty());
        this.autoCompleteFields.setConverter(((AutoCompletionTabViewModel)this.viewModel).getFieldStringConverter());
        this.autoCompleteFields.setTagViewFactory(this::createTag);
        this.autoCompleteFields.setShowSearchIcon(false);
        this.autoCompleteFields.getEditor().getStyleClass().clear();
        this.autoCompleteFields.getEditor().getStyleClass().add((Object)"tags-field-editor");
    }

    private Node createTag(Field field) {
        Label tagLabel = new Label();
        tagLabel.setText(field.getDisplayName());
        tagLabel.setGraphic(IconTheme.JabRefIcons.REMOVE_TAGS.getGraphicNode());
        tagLabel.getGraphic().setOnMouseClicked(event -> this.autoCompleteFields.removeTags((Object[])new Field[]{field}));
        tagLabel.setContentDisplay(ContentDisplay.RIGHT);
        return tagLabel;
    }
}

