/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.nameformatter;

import java.util.ArrayList;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.preferences.nameformatter.NameFormatterItemModel;
import org.jabref.logic.layout.format.NameFormatterPreferences;
import org.jabref.model.strings.StringUtil;

public class NameFormatterTabViewModel
implements PreferenceTabViewModel {
    private final ListProperty<NameFormatterItemModel> formatterListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final StringProperty addFormatterNameProperty = new SimpleStringProperty();
    private final StringProperty addFormatterStringProperty = new SimpleStringProperty();
    private final NameFormatterPreferences nameFormatterPreferences;

    NameFormatterTabViewModel(NameFormatterPreferences preferences) {
        this.nameFormatterPreferences = preferences;
    }

    @Override
    public void setValues() {
        this.formatterListProperty.clear();
        ObservableList<String> names = this.nameFormatterPreferences.getNameFormatterKey();
        ObservableList<String> formats = this.nameFormatterPreferences.getNameFormatterValue();
        for (int i = 0; i < names.size(); ++i) {
            if (i < formats.size()) {
                this.formatterListProperty.add((Object)new NameFormatterItemModel((String)names.get(i), (String)formats.get(i)));
                continue;
            }
            this.formatterListProperty.add((Object)new NameFormatterItemModel((String)names.get(i)));
        }
    }

    @Override
    public void storeSettings() {
        this.formatterListProperty.removeIf(formatter -> formatter.getName().isEmpty());
        ArrayList<String> names = new ArrayList<String>(this.formatterListProperty.size());
        ArrayList<String> formats = new ArrayList<String>(this.formatterListProperty.size());
        for (NameFormatterItemModel formatterListItem : this.formatterListProperty) {
            names.add(formatterListItem.getName());
            formats.add(formatterListItem.getFormat());
        }
        this.nameFormatterPreferences.setNameFormatterKey(names);
        this.nameFormatterPreferences.setNameFormatterValue(formats);
    }

    public void addFormatter() {
        if (!StringUtil.isNullOrEmpty(this.addFormatterNameProperty.getValue()) && !StringUtil.isNullOrEmpty(this.addFormatterStringProperty.getValue())) {
            this.formatterListProperty.add((Object)new NameFormatterItemModel(this.addFormatterNameProperty.getValue(), this.addFormatterStringProperty.getValue()));
            this.addFormatterNameProperty.setValue("");
            this.addFormatterStringProperty.setValue("");
        }
    }

    public void removeFormatter(NameFormatterItemModel formatter) {
        this.formatterListProperty.remove((Object)formatter);
    }

    public ListProperty<NameFormatterItemModel> formatterListProperty() {
        return this.formatterListProperty;
    }

    public StringProperty addFormatterNameProperty() {
        return this.addFormatterNameProperty;
    }

    public StringProperty addFormatterStringProperty() {
        return this.addFormatterStringProperty;
    }
}

