/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.UpdateField;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialFieldAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecialFieldAction.class);
    private final Supplier<LibraryTab> tabSupplier;
    private final SpecialField specialField;
    private final String value;
    private final boolean nullFieldIfValueIsTheSame;
    private final String undoText;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final UndoManager undoManager;
    private final StateManager stateManager;

    public SpecialFieldAction(Supplier<LibraryTab> tabSupplier, SpecialField specialField, String value, boolean nullFieldIfValueIsTheSame, String undoText, DialogService dialogService, PreferencesService preferencesService, UndoManager undoManager, StateManager stateManager) {
        this.tabSupplier = tabSupplier;
        this.specialField = specialField;
        this.value = value;
        this.nullFieldIfValueIsTheSame = nullFieldIfValueIsTheSame;
        this.undoText = undoText;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.undoManager = undoManager;
        this.stateManager = stateManager;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        try {
            ObservableList<BibEntry> bes = this.stateManager.getSelectedEntries();
            if (bes == null || bes.isEmpty()) {
                return;
            }
            NamedCompound ce = new NamedCompound(this.undoText);
            ArrayList<BibEntry> besCopy = new ArrayList<BibEntry>((Collection<BibEntry>)bes);
            for (BibEntry bibEntry : besCopy) {
                Optional<FieldChange> change = UpdateField.updateField(bibEntry, this.specialField, this.value, this.nullFieldIfValueIsTheSame);
                change.ifPresent(fieldChange -> ce.addEdit(new UndoableFieldChange((FieldChange)fieldChange)));
            }
            ce.end();
            if (ce.hasEdits()) {
                this.undoManager.addEdit(ce);
                this.tabSupplier.get().markBaseChanged();
                this.tabSupplier.get().updateEntryEditorIfShowing();
                String outText = this.nullFieldIfValueIsTheSame || this.value == null ? this.getTextDone(this.specialField, Integer.toString(bes.size())) : this.getTextDone(this.specialField, this.value, Integer.toString(bes.size()));
                this.dialogService.notify(outText);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("Problem setting special fields", ex);
        }
    }

    private String getTextDone(SpecialField field, String ... params) {
        Objects.requireNonNull(params);
        SpecialFieldViewModel viewModel = new SpecialFieldViewModel(field, this.preferencesService, this.undoManager);
        if (field.isSingleValueField() && params.length == 1 && params[0] != null) {
            return Localization.lang("Toggled '%0' for %1 entries", viewModel.getLocalization(), params[0]);
        }
        if (!field.isSingleValueField() && params.length == 2 && params[0] != null && params[1] != null) {
            Object[] allParams = new String[]{viewModel.getLocalization(), params[0], params[1]};
            return Localization.lang("Set '%0' to '%1' for %2 entries", allParams);
        }
        if (!field.isSingleValueField() && params.length == 1 && params[0] != null) {
            return Localization.lang("Cleared '%0' for %1 entries", viewModel.getLocalization(), params[0]);
        }
        LOGGER.info("Creation of special field status change message failed: illegal argument combination.");
        return "";
    }
}

