/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.logic.l10n.Localization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNodeViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileNodeViewModel.class);
    private final Path path;
    private final ObservableList<FileNodeViewModel> children;
    private int fileCount;

    public FileNodeViewModel(Path path) {
        this.path = path;
        this.children = FXCollections.observableArrayList();
        this.fileCount = 0;
    }

    public Path getPath() {
        return this.path;
    }

    public ObservableList<FileNodeViewModel> getChildren() {
        return new ReadOnlyListWrapper(this.children);
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public static String formatDateTime(FileTime fileTime) {
        LocalDateTime localDateTime = fileTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
    }

    public String getDisplayText() {
        if (this.path.toFile().isDirectory()) {
            return "%s (%s %s)".formatted(this.path.getFileName(), this.fileCount, this.fileCount == 1 ? Localization.lang("file", new Object[0]) : Localization.lang("files", new Object[0]));
        }
        return this.path.getFileName().toString();
    }

    public String getDisplayTextWithEditDate() {
        if (this.path.toFile().isDirectory()) {
            return "%s (%s %s)".formatted(this.path.getFileName(), this.fileCount, this.fileCount == 1 ? Localization.lang("file", new Object[0]) : Localization.lang("files", new Object[0]));
        }
        FileTime lastEditedTime = null;
        try {
            lastEditedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Exception Caught", (Throwable)e);
        }
        return "%s (%s: %s)".formatted(this.path.getFileName().toString(), Localization.lang("last edited", new Object[0]), FileNodeViewModel.formatDateTime(lastEditedTime));
    }

    public String toString() {
        return "FileNodeViewModel{path=%s, children=%s, fileCount=%s}".formatted(this.path, this.children, this.fileCount);
    }

    public int hashCode() {
        return Objects.hash(this.children, this.fileCount, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileNodeViewModel)) {
            return false;
        }
        FileNodeViewModel other = (FileNodeViewModel)obj;
        return Objects.equals(this.children, other.children) && this.fileCount == other.fileCount && Objects.equals(this.path, other.path);
    }
}

