/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.jabref.gui.icon.JabRefIcon;

public class ViewModelTreeCellFactory<T>
implements Callback<TreeView<T>, TreeCell<T>> {
    private Callback<T, String> toText;
    private Callback<T, Node> toGraphic;
    private Callback<T, EventHandler<? super MouseEvent>> toOnMouseClickedEvent;
    private Callback<T, String> toTooltip;

    public ViewModelTreeCellFactory<T> withText(Callback<T, String> toText) {
        this.toText = toText;
        return this;
    }

    public ViewModelTreeCellFactory<T> withGraphic(Callback<T, Node> toGraphic) {
        this.toGraphic = toGraphic;
        return this;
    }

    public ViewModelTreeCellFactory<T> withIcon(Callback<T, JabRefIcon> toIcon) {
        this.toGraphic = viewModel -> ((JabRefIcon)toIcon.call(viewModel)).getGraphicNode();
        return this;
    }

    public ViewModelTreeCellFactory<T> withTooltip(Callback<T, String> toTooltip) {
        this.toTooltip = toTooltip;
        return this;
    }

    public ViewModelTreeCellFactory<T> withOnMouseClickedEvent(Callback<T, EventHandler<? super MouseEvent>> toOnMouseClickedEvent) {
        this.toOnMouseClickedEvent = toOnMouseClickedEvent;
        return this;
    }

    public void install(TreeView<T> treeView) {
        treeView.setCellFactory((Callback)this);
    }

    public TreeCell<T> call(TreeView<T> tree) {
        Callback getSelectedProperty = item -> {
            if (item instanceof CheckBoxTreeItem) {
                CheckBoxTreeItem treeItem = (CheckBoxTreeItem)item;
                return treeItem.selectedProperty();
            }
            return null;
        };
        StringConverter converter = new StringConverter<TreeItem<T>>(){

            public String toString(TreeItem<T> treeItem) {
                return treeItem == null || treeItem.getValue() == null || ViewModelTreeCellFactory.this.toText == null ? "" : (String)ViewModelTreeCellFactory.this.toText.call(treeItem.getValue());
            }

            public TreeItem<T> fromString(String string) {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
        return new CheckBoxTreeCell(getSelectedProperty, converter);
    }
}

