/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javafx.util.Pair;
import kong.unirest.core.HttpRequestWithBody;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.JsonNode;
import kong.unirest.core.Unirest;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONElement;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.WebFetcher;
import org.jabref.logic.journals.JournalInformation;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.identifier.ISSN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalInformationFetcher
implements WebFetcher {
    public static final String NAME = "Journal Information";
    private static final Logger LOGGER = LoggerFactory.getLogger(JournalInformationFetcher.class);
    private static final String API_URL = "https://jabref.org/api";
    private static final Pattern QUOTES_BRACKET_PATTERN = Pattern.compile("[\"\\[\\]]");

    @Override
    public String getName() {
        return NAME;
    }

    public Optional<JournalInformation> getJournalInformation(String issnString, String journalName) throws FetcherException {
        ISSN issn = new ISSN(issnString);
        String cleanedISSN = "";
        if (issn.isValidFormat() || issn.isCanBeCleaned()) {
            cleanedISSN = issn.getCleanedISSN();
        } else {
            LOGGER.warn(Localization.lang("Incorrect ISSN format", new Object[0]));
        }
        Optional<JournalInformation> journalInformationOptional = Optional.empty();
        JSONObject postData = this.buildPostData(cleanedISSN, journalName);
        HttpResponse httpResponse = ((HttpRequestWithBody)Unirest.post((String)API_URL).header("Content-Type", "application/json")).body((JSONElement)postData).asJson();
        if (httpResponse.getBody() != null) {
            JSONObject responseJsonObject = ((JsonNode)httpResponse.getBody()).getObject();
            journalInformationOptional = Optional.of(this.parseResponse(responseJsonObject));
        }
        return journalInformationOptional;
    }

    private JournalInformation parseResponse(JSONObject responseJsonObject) throws FetcherException {
        List<Pair<Integer, Double>> citesIncomingPerDocByRecentlyPublished;
        List<Pair<Integer, Double>> citesIncomingByRecentlyPublished;
        List<Pair<Integer, Double>> citesOutgoingPerDoc;
        ArrayList<Pair<Integer, Double>> citesOutgoing;
        ArrayList<Pair<Integer, Double>> citableDocsPrevious3Years;
        ArrayList<Pair<Integer, Double>> docsPrevious3Years;
        ArrayList<Pair<Integer, Double>> docsThisYear;
        List<Pair<Integer, Double>> snipArray;
        List<Pair<Integer, Double>> sjrArray;
        String issn;
        String hIndex;
        String scimagoId;
        String categories;
        String country;
        String subjectArea;
        String coverageEndYear;
        String coverageStartYear;
        String publisher;
        String title;
        block7: {
            title = "";
            publisher = "";
            coverageStartYear = "";
            coverageEndYear = "";
            subjectArea = "";
            country = "";
            categories = "";
            scimagoId = "";
            hIndex = "";
            issn = "";
            sjrArray = new ArrayList<Pair<Integer, Double>>();
            snipArray = new ArrayList<Pair<Integer, Double>>();
            docsThisYear = new ArrayList();
            docsPrevious3Years = new ArrayList();
            citableDocsPrevious3Years = new ArrayList();
            citesOutgoing = new ArrayList();
            citesOutgoingPerDoc = new ArrayList<Pair<Integer, Double>>();
            citesIncomingByRecentlyPublished = new ArrayList<Pair<Integer, Double>>();
            citesIncomingPerDocByRecentlyPublished = new ArrayList<Pair<Integer, Double>>();
            try {
                if (responseJsonObject.has("errors")) {
                    JSONArray errors = responseJsonObject.optJSONArray("errors");
                    if (errors != null && !errors.isEmpty()) {
                        JSONObject error = errors.getJSONObject(0);
                        String errorMessage = error.optString("message", "");
                        LOGGER.error("Error accessing catalog: {}", (Object)errorMessage);
                    }
                    throw new FetcherException(Localization.lang("Error accessing catalog", new Object[0]));
                }
                if (responseJsonObject.has("data")) {
                    JSONObject data = responseJsonObject.getJSONObject("data");
                    if (data.has("journal") && data.get("journal") != null) {
                        JSONObject journalData = data.getJSONObject("journal");
                        title = journalData.optString("name", "");
                        publisher = journalData.optString("publisher", "");
                        coverageStartYear = journalData.optString("coverageStartYear", "");
                        coverageEndYear = journalData.optString("coverageEndYear", "");
                        scimagoId = journalData.optString("scimagoId", "");
                        country = journalData.optString("country", "");
                        issn = JournalInformationFetcher.getConcatenatedString(journalData, "issn");
                        subjectArea = JournalInformationFetcher.getConcatenatedString(journalData, "areas");
                        categories = JournalInformationFetcher.getConcatenatedString(journalData, "categories");
                        hIndex = journalData.optString("hIndex", "");
                        JSONArray citationInfo = journalData.optJSONArray("citationInfo");
                        if (citationInfo != null) {
                            docsThisYear = this.parseCitationInfo(citationInfo, "docsThisYear");
                            docsPrevious3Years = this.parseCitationInfo(citationInfo, "docsPrevious3Years");
                            citableDocsPrevious3Years = this.parseCitationInfo(citationInfo, "citableDocsPrevious3Years");
                            citesOutgoing = this.parseCitationInfo(citationInfo, "citesOutgoing");
                            citesOutgoingPerDoc = this.parseCitationInfo(citationInfo, "citesOutgoingPerDoc");
                            citesIncomingByRecentlyPublished = this.parseCitationInfo(citationInfo, "citesIncomingByRecentlyPublished");
                            citesIncomingPerDocByRecentlyPublished = this.parseCitationInfo(citationInfo, "citesIncomingPerDocByRecentlyPublished");
                            sjrArray = this.parseCitationInfo(citationInfo, "sjrIndex");
                            snipArray = this.parseCitationInfo(citationInfo, "snipIndex");
                        }
                        break block7;
                    }
                    throw new FetcherException(Localization.lang("ISSN and/or journal name not found in catalog", new Object[0]));
                }
                throw new FetcherException(Localization.lang("ISSN and/or journal name not found in catalog", new Object[0]));
            }
            catch (JSONException e) {
                throw new FetcherException(Localization.lang("Parsing error", new Object[0]), e);
            }
        }
        return new JournalInformation(title, publisher, coverageStartYear, coverageEndYear, subjectArea, country, categories, scimagoId, hIndex, issn, sjrArray, snipArray, docsThisYear, docsPrevious3Years, citableDocsPrevious3Years, citesOutgoing, citesOutgoingPerDoc, citesIncomingByRecentlyPublished, citesIncomingPerDocByRecentlyPublished);
    }

    private static String getConcatenatedString(JSONObject jsonObject, String key) {
        JSONArray jsonArray = jsonObject.optJSONArray(key);
        if (jsonArray != null) {
            return QUOTES_BRACKET_PATTERN.matcher(jsonArray.join(", ")).replaceAll("");
        }
        return "";
    }

    private JSONObject buildPostData(String issn, String journalName) {
        String query = "query GetJournal($issn: String, $name: String) {\n  journal(issn: $issn, name: $name) {\n    id\n    name\n    issn\n    scimagoId\n    country\n    publisher\n    areas\n    categories\n    citationInfo {\n      year\n      docsThisYear\n      docsPrevious3Years\n      citableDocsPrevious3Years\n      citesOutgoing\n      citesOutgoingPerDoc\n      citesIncomingByRecentlyPublished\n      citesIncomingPerDocByRecentlyPublished\n      sjrIndex\n    }\n    hIndex\n  }\n}";
        JSONObject postData = new JSONObject();
        postData.put("query", query);
        postData.put("operationName", "GetJournal");
        JSONObject variables = new JSONObject();
        variables.put("issn", issn);
        variables.put("name", journalName);
        postData.put("variables", variables);
        return postData;
    }

    private List<Pair<Integer, Double>> parseCitationInfo(JSONArray jsonArray, String key) {
        ArrayList<Pair<Integer, Double>> parsedArray = new ArrayList<Pair<Integer, Double>>();
        HashSet<Integer> yearSet = new HashSet<Integer>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject item = jsonArray.getJSONObject(i);
            if (!item.has("year") || !item.has(key)) continue;
            int year = item.getInt("year");
            double value = item.getDouble(key);
            if (yearSet.contains(year)) continue;
            parsedArray.add((Pair<Integer, Double>)new Pair((Object)year, (Object)value));
            yearSet.add(year);
        }
        parsedArray.sort(Comparator.comparing(Pair::getKey));
        return parsedArray;
    }
}

