/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jabref.logic.citationkeypattern.CitationKeyPattern;
import org.jabref.logic.cleanup.FieldFormatterCleanups;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.util.GroupsParser;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypeBuilder;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.EntryTypeFactory;
import org.jabref.model.metadata.ContentSelectors;
import org.jabref.model.metadata.MetaData;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaDataParser.class);
    private static FileUpdateMonitor fileMonitor;
    private static final Pattern SINGLE_BACKSLASH;

    public MetaDataParser(FileUpdateMonitor fileMonitor) {
        MetaDataParser.fileMonitor = fileMonitor;
    }

    public static Optional<BibEntryType> parseCustomEntryType(String comment) {
        String rest = comment.substring("jabref-entrytype: ".length());
        int indexEndOfName = rest.indexOf(58);
        if (indexEndOfName < 0) {
            return Optional.empty();
        }
        String fieldsDescription = rest.substring(indexEndOfName + 2);
        int indexEndOfRequiredFields = fieldsDescription.indexOf(93);
        int indexEndOfOptionalFields = fieldsDescription.indexOf(93, indexEndOfRequiredFields + 1);
        if (indexEndOfRequiredFields < 4 || indexEndOfOptionalFields < indexEndOfRequiredFields + 6) {
            return Optional.empty();
        }
        EntryType type = EntryTypeFactory.parse(rest.substring(0, indexEndOfName));
        String reqFields = fieldsDescription.substring(4, indexEndOfRequiredFields);
        String optFields = fieldsDescription.substring(indexEndOfRequiredFields + 6, indexEndOfOptionalFields);
        BibEntryTypeBuilder entryTypeBuilder = new BibEntryTypeBuilder().withType(type).withRequiredFields(FieldFactory.parseOrFieldsList(reqFields)).withImportantFields(FieldFactory.parseFieldList(optFields));
        if (entryTypeBuilder.hasWarnings()) {
            LOGGER.warn("Following custom entry type definition has duplicate fields: {}", (Object)comment);
            return Optional.empty();
        }
        return Optional.of(entryTypeBuilder.build());
    }

    public MetaData parse(Map<String, String> data, Character keywordSeparator) throws ParseException {
        return this.parse(new MetaData(), data, keywordSeparator);
    }

    public MetaData parse(MetaData metaData, Map<String, String> data, Character keywordSeparator) throws ParseException {
        CitationKeyPattern defaultCiteKeyPattern = CitationKeyPattern.NULL_CITATION_KEY_PATTERN;
        HashMap<EntryType, CitationKeyPattern> nonDefaultCiteKeyPatterns = new HashMap<EntryType, CitationKeyPattern>();
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(data.entrySet());
        entryList.sort(MetaDataParser.groupsLast());
        for (Map.Entry entry : entryList) {
            String user;
            List<String> values = MetaDataParser.getAsList((String)entry.getValue());
            if (((String)entry.getKey()).startsWith("keypattern_")) {
                EntryType entryType = EntryTypeFactory.parse(((String)entry.getKey()).substring("keypattern_".length()));
                nonDefaultCiteKeyPatterns.put(entryType, new CitationKeyPattern(MetaDataParser.getSingleItem(values)));
                continue;
            }
            if (((String)entry.getKey()).startsWith("selector_")) {
                metaData.addContentSelector(ContentSelectors.parse(FieldFactory.parseField(((String)entry.getKey()).substring("selector_".length())), StringUtil.unquote((String)entry.getValue(), '\\')));
                continue;
            }
            if (((String)entry.getKey()).equals("fileDirectory")) {
                metaData.setDefaultFileDirectory(MetaDataParser.parseDirectory((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).startsWith("fileDirectory-")) {
                user = ((String)entry.getKey()).substring("fileDirectory".length() + 1);
                metaData.setUserFileDirectory(user, MetaDataParser.parseDirectory((String)entry.getValue()));
                continue;
            }
            if (((String)entry.getKey()).startsWith("fileDirectoryLatex")) {
                user = ((String)entry.getKey()).substring("fileDirectoryLatex".length() + 1);
                Path path = Path.of(MetaDataParser.parseDirectory((String)entry.getValue()), new String[0]).normalize();
                metaData.setLatexFileDirectory(user, path);
                continue;
            }
            if (((String)entry.getKey()).equals("saveActions")) {
                metaData.setSaveActions(FieldFormatterCleanups.parse(values));
                continue;
            }
            if (((String)entry.getKey()).equals("databaseType")) {
                metaData.setMode(BibDatabaseMode.parse(MetaDataParser.getSingleItem(values)));
                continue;
            }
            if (((String)entry.getKey()).equals("keypatterndefault")) {
                defaultCiteKeyPattern = new CitationKeyPattern(MetaDataParser.getSingleItem(values));
                continue;
            }
            if (((String)entry.getKey()).equals("protectedFlag")) {
                if (Boolean.parseBoolean(MetaDataParser.getSingleItem(values))) {
                    metaData.markAsProtected();
                    continue;
                }
                metaData.markAsNotProtected();
                continue;
            }
            if (((String)entry.getKey()).equals("saveOrderConfig")) {
                metaData.setSaveOrder(SaveOrder.parse(values));
                continue;
            }
            if (((String)entry.getKey()).equals("grouping") || ((String)entry.getKey()).equals("groupstree")) {
                metaData.setGroups(GroupsParser.importGroups(values, keywordSeparator, fileMonitor, metaData));
                continue;
            }
            if (((String)entry.getKey()).equals("VersionDBStructure")) {
                metaData.setVersionDBStructure(MetaDataParser.getSingleItem(values));
                continue;
            }
            metaData.putUnknownMetaDataItem((String)entry.getKey(), values);
        }
        if (!defaultCiteKeyPattern.equals(CitationKeyPattern.NULL_CITATION_KEY_PATTERN) || !nonDefaultCiteKeyPatterns.isEmpty()) {
            metaData.setCiteKeyPattern(defaultCiteKeyPattern, nonDefaultCiteKeyPatterns);
        }
        return metaData;
    }

    static String parseDirectory(String value) {
        if ((value = StringUtil.removeStringAtTheEnd(value, MetaData.SEPARATOR_STRING)).contains("\\\\\\\\")) {
            return value.replace("\\\\", "\\");
        }
        if (value.contains("\\\\") && !SINGLE_BACKSLASH.matcher(value).find()) {
            return value.replace("\\\\", "\\");
        }
        return value;
    }

    private static Comparator<? super Map.Entry<String, String>> groupsLast() {
        return (s1, s2) -> "grouping".equals(s1.getKey()) || "groupstree".equals(s1.getKey()) ? 1 : ("grouping".equals(s2.getKey()) || "groupstree".equals(s2.getKey()) ? -1 : 0);
    }

    private static String getSingleItem(List<String> value) throws ParseException {
        if (value.size() == 1) {
            return value.getFirst();
        }
        throw new ParseException("Expected a single item but received " + String.valueOf(value));
    }

    private static List<String> getAsList(String value) throws ParseException {
        StringReader valueReader = new StringReader(value);
        ArrayList<String> orderedValue = new ArrayList<String>();
        try {
            Optional<String> unit;
            while ((unit = MetaDataParser.getNextUnit(valueReader)).isPresent()) {
                orderedValue.add(unit.get());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Weird error while parsing meta data.", (Throwable)ex);
            throw new ParseException("Weird error while parsing meta data.", ex);
        }
        return orderedValue;
    }

    private static Optional<String> getNextUnit(Reader reader) throws IOException {
        int c;
        boolean escape = false;
        StringBuilder res = new StringBuilder();
        while ((c = reader.read()) != -1) {
            if (escape) {
                char character = (char)c;
                if (character != ';' && character != '\\') {
                    res.append("\\");
                }
                res.append(character);
                escape = false;
                continue;
            }
            if (c == 92) {
                escape = true;
                continue;
            }
            if (c == 59) break;
            res.append((char)c);
        }
        if (res.length() > 0) {
            return Optional.of(res.toString());
        }
        return Optional.empty();
    }

    static {
        SINGLE_BACKSLASH = Pattern.compile("[^\\\\]\\\\[^\\\\]");
    }
}

