/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.HashMap;
import java.util.Map;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.logic.util.strings.XmlCharsMap;

public class XMLChars
implements LayoutFormatter {
    private static final XmlCharsMap XML_CHARS = new XmlCharsMap();
    private static final Map<String, String> ASCII_TO_XML_CHARS = new HashMap<String, String>();
    private boolean[] forceReplace;

    @Override
    public String format(String fieldText) {
        if (fieldText == null) {
            return fieldText;
        }
        String latexCommandFree = this.removeLatexCommands(fieldText);
        String formattedFieldText = XMLChars.firstFormat(latexCommandFree);
        for (Map.Entry entry : XML_CHARS.entrySet()) {
            String s = (String)entry.getKey();
            String repl = (String)entry.getValue();
            if (repl == null) continue;
            formattedFieldText = formattedFieldText.replaceAll(s, repl);
        }
        return this.restFormat(formattedFieldText);
    }

    private String removeLatexCommands(String fieldText) {
        LatexToUnicodeFormatter latexToUnicode = new LatexToUnicodeFormatter();
        return latexToUnicode.format(fieldText);
    }

    private static String firstFormat(String s) {
        return s.replaceAll("&|\\\\&", "&#x0026;").replace("--", "&#x2013;");
    }

    private String restFormat(String toFormat) {
        String fieldText = toFormat.replace("}", "").replace("{", "");
        if (this.forceReplace == null) {
            this.forceReplace = new boolean[126];
            for (int i = 0; i < 40; ++i) {
                this.forceReplace[i] = true;
            }
            this.forceReplace[32] = false;
            for (int i : new int[]{44, 45, 63, 64, 94, 95, 96, 124}) {
                this.forceReplace[i] = true;
            }
        }
        StringBuilder buffer = new StringBuilder(fieldText.length() * 2);
        for (int i = 0; i < fieldText.length(); ++i) {
            char code = fieldText.charAt(i);
            if (code == '&' && fieldText.charAt(i + 1) == '#') {
                buffer.append("&#");
                code = fieldText.charAt(i += 2);
            }
            if (code > '}' || this.forceReplace[code]) {
                buffer.append("&#").append((int)code).append(';');
                continue;
            }
            buffer.append(code);
        }
        fieldText = buffer.toString();
        for (Map.Entry<String, String> entry : ASCII_TO_XML_CHARS.entrySet()) {
            fieldText = fieldText.replace(entry.getKey(), entry.getValue());
        }
        return fieldText;
    }

    static {
        ASCII_TO_XML_CHARS.put("<", "&lt;");
        ASCII_TO_XML_CHARS.put("\"", "&quot;");
        ASCII_TO_XML_CHARS.put(">", "&gt;");
    }
}

