/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.util.ArrayDeque;
import java.util.Queue;
import javafx.application.Platform;
import javafx.scene.web.WebView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebViewStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebViewStore.class);
    private static final Queue<WebView> WEB_VIEWS = new ArrayDeque<WebView>();
    private static boolean isInitialized = false;
    private static Configuration config;

    public static void init(Configuration config) {
        WebViewStore.config = config;
        for (int i = 0; i < config.getNumberOfPreloadedInstances(); ++i) {
            WebViewStore.addWebViewLater();
        }
        isInitialized = true;
    }

    public static void init() {
        WebViewStore.init(new Configuration(4, 2));
    }

    public static WebView get() {
        if (!isInitialized) {
            throw new IllegalStateException("WebViewStore is uninitialized");
        }
        if (WEB_VIEWS.size() <= config.getMinimumNumberOfInstances()) {
            WebViewStore.addWebViewLater();
        }
        if (WebViewStore.hasMore()) {
            return WEB_VIEWS.poll();
        }
        return new WebView();
    }

    private static void addWebViewLater() {
        Platform.runLater(() -> {
            WEB_VIEWS.add(new WebView());
            LOGGER.debug("Cached Web views: {}", (Object)WEB_VIEWS.size());
        });
    }

    public static boolean hasMore() {
        return !WEB_VIEWS.isEmpty();
    }

    public record Configuration(int numberOfPreloadedInstances, int minimumNumberOfInstances) {
        public int getNumberOfPreloadedInstances() {
            return this.numberOfPreloadedInstances;
        }

        public int getMinimumNumberOfInstances() {
            return this.minimumNumberOfInstances;
        }
    }
}

