/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.types;

import java.util.Locale;
import java.util.Objects;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.strings.StringUtil;

public class UnknownEntryType
implements EntryType {
    private final String name;

    public UnknownEntryType(String name) {
        this.name = Objects.requireNonNull(name).toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return "UnknownEntryType{name='" + this.name + "'}";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return StringUtil.capitalizeFirst(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnknownEntryType that = (UnknownEntryType)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

