/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.metadata.SelfContainedSaveOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveOrder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveOrder.class);
    private final OrderType orderType;
    private final List<SortCriterion> sortCriteria;

    public SaveOrder(OrderType orderType, List<SortCriterion> sortCriteria) {
        this.orderType = orderType;
        this.sortCriteria = sortCriteria;
    }

    private SaveOrder(List<String> data) {
        OrderType orderType;
        Objects.requireNonNull(data);
        if (data.isEmpty()) {
            throw new IllegalArgumentException();
        }
        try {
            orderType = OrderType.valueOf(data.getFirst().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (data.size() > 1 && data.size() % 2 == 1) {
                LOGGER.warn("Could not parse sort order: {} - trying to parse the sort criteria", (Object)data.getFirst());
                orderType = OrderType.SPECIFIED;
            }
            LOGGER.warn("Could not parse sort order: {}", (Object)data.getFirst());
            this.sortCriteria = List.of();
            this.orderType = OrderType.ORIGINAL;
            return;
        }
        this.orderType = orderType;
        ArrayList<SortCriterion> sortCriteria = new ArrayList<SortCriterion>(data.size() / 2);
        for (int index = 1; index < data.size(); index += 2) {
            sortCriteria.add(new SortCriterion(FieldFactory.parseField(data.get(index)), data.get(index + 1)));
        }
        this.sortCriteria = sortCriteria;
    }

    public static SaveOrder parse(List<String> orderedData) {
        return new SaveOrder(orderedData);
    }

    public static SelfContainedSaveOrder getDefaultSaveOrder() {
        return new SelfContainedSaveOrder(OrderType.ORIGINAL, List.of());
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public List<SortCriterion> getSortCriteria() {
        return this.sortCriteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SaveOrder) {
            SaveOrder that = (SaveOrder)o;
            return Objects.equals(this.sortCriteria, that.sortCriteria) && Objects.equals((Object)this.orderType, (Object)that.orderType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.orderType, this.sortCriteria});
    }

    public String toString() {
        return "SaveOrderConfig{orderType=" + this.orderType.toString() + ", sortCriteria=" + String.valueOf(this.sortCriteria) + "}";
    }

    public List<String> getAsStringList() {
        ArrayList<String> res = new ArrayList<String>(7);
        res.add(this.orderType.toString());
        for (SortCriterion sortCriterion : this.sortCriteria) {
            res.add(sortCriterion.field.getName());
            res.add(Boolean.toString(sortCriterion.descending));
        }
        return res;
    }

    public static enum OrderType {
        SPECIFIED("specified"),
        ORIGINAL("original"),
        TABLE("table");

        private final String name;

        private OrderType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static OrderType fromBooleans(boolean saveInSpecifiedOrder, boolean saveInOriginalOrder) {
            OrderType orderType = TABLE;
            if (saveInSpecifiedOrder) {
                orderType = SPECIFIED;
            } else if (saveInOriginalOrder) {
                orderType = ORIGINAL;
            }
            return orderType;
        }
    }

    public static class SortCriterion {
        public final Field field;
        public final boolean descending;

        public SortCriterion(Field field) {
            this(field, false);
        }

        public SortCriterion(Field field, String descending) {
            this.field = field;
            this.descending = Boolean.parseBoolean(descending);
        }

        public SortCriterion(Field field, boolean descending) {
            this.field = field;
            this.descending = descending;
        }

        public String toString() {
            return "SortCriterion{field='" + String.valueOf(this.field) + "', descending=" + this.descending + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortCriterion that = (SortCriterion)o;
            return Objects.equals(this.descending, that.descending) && Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.descending);
        }
    }
}

