/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.util.Map;
import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import org.jabref.gui.sidepane.SidePaneType;

public class SidePanePreferences {
    private final ObservableSet<SidePaneType> visiblePanes;
    private final ObservableMap<SidePaneType, Integer> preferredPositions;
    private final IntegerProperty webSearchFetcherSelected;

    public SidePanePreferences(Set<SidePaneType> visiblePanes, Map<SidePaneType, Integer> preferredPositions, int webSearchFetcherSelected) {
        this.visiblePanes = FXCollections.observableSet(visiblePanes);
        this.preferredPositions = FXCollections.observableMap(preferredPositions);
        this.webSearchFetcherSelected = new SimpleIntegerProperty(webSearchFetcherSelected);
    }

    public ObservableSet<SidePaneType> visiblePanes() {
        return this.visiblePanes;
    }

    public ObservableMap<SidePaneType, Integer> getPreferredPositions() {
        return this.preferredPositions;
    }

    public void setPreferredPositions(Map<SidePaneType, Integer> positions) {
        this.preferredPositions.clear();
        this.preferredPositions.putAll(positions);
    }

    public int getWebSearchFetcherSelected() {
        return this.webSearchFetcherSelected.get();
    }

    public IntegerProperty webSearchFetcherSelectedProperty() {
        return this.webSearchFetcherSelected;
    }

    public void setWebSearchFetcherSelected(int webSearchFetcherSelected) {
        this.webSearchFetcherSelected.set(webSearchFetcherSelected);
    }
}

