/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.utilities;

import java.util.regex.Pattern;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.utilities.MathMLUtilities;

public final class SnuggleUtilities {
    private static final Pattern charsToVerbPattern = Pattern.compile("([\\\\^~<>|]+)");
    private static final Pattern charsToBackslashPattern = Pattern.compile("([%#_$&\\{\\}])");

    public static String quoteTextForInput(String text) {
        String result = charsToVerbPattern.matcher(text).replaceAll("\\\\verb-$1-");
        result = charsToBackslashPattern.matcher(result).replaceAll("\\\\$1");
        return result;
    }

    public static String extractSnuggleTeXAnnotation(Element mathmlElement) {
        return MathMLUtilities.extractAnnotationString(mathmlElement, "SnuggleTeX");
    }
}

