/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.airhacks.afterburner.injection.Injector;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.MouseButton;
import org.jabref.architecture.AllowedToUseAwt;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.FieldWriter;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.BibtexString;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseAwt(value="Requires ava.awt.datatransfer.Clipboard")
public class ClipBoardManager {
    public static final DataFormat XML = new DataFormat(new String[]{"application/xml"});
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipBoardManager.class);
    private static javafx.scene.input.Clipboard clipboard;
    private static Clipboard primary;

    public ClipBoardManager() {
        this(javafx.scene.input.Clipboard.getSystemClipboard(), Toolkit.getDefaultToolkit().getSystemSelection());
    }

    public ClipBoardManager(javafx.scene.input.Clipboard clipboard, Clipboard primary) {
        ClipBoardManager.clipboard = clipboard;
        ClipBoardManager.primary = primary;
    }

    public static void addX11Support(TextInputControl input) {
        input.selectedTextProperty().addListener(observable -> Platform.runLater(() -> {
            String newValue = input.getSelectedText();
            if (!newValue.isEmpty() && primary != null) {
                primary.setContents(new StringSelection(newValue), null);
            }
        }));
        input.setOnMouseClicked(event -> {
            if (event.getButton() == MouseButton.MIDDLE) {
                input.insertText(input.getCaretPosition(), ClipBoardManager.getContentsPrimary());
            }
        });
    }

    public static String getContents() {
        String result = clipboard.getString();
        if (result == null) {
            return "";
        }
        return result;
    }

    public static String getHtmlContents() {
        String result = clipboard.getHtml();
        if (result == null) {
            return "";
        }
        return result;
    }

    public static boolean hasHtml() {
        return clipboard.hasHtml();
    }

    public static String getContentsPrimary() {
        Transferable contents;
        if (primary != null && (contents = primary.getContents(null)) != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                return (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        return ClipBoardManager.getContents();
    }

    public void setContent(ClipboardContent content) {
        clipboard.setContent((Map)content);
        this.setPrimaryClipboardContent(content);
    }

    public void setPrimaryClipboardContent(ClipboardContent content) {
        if (primary != null) {
            primary.setContents(new StringSelection(content.getString()), null);
        }
    }

    public void setHtmlContent(String html, String fallbackPlain) {
        ClipboardContent content = new ClipboardContent();
        content.putHtml(html);
        content.putString(fallbackPlain);
        clipboard.setContent((Map)content);
        this.setPrimaryClipboardContent(content);
    }

    public void setContent(String string) {
        ClipboardContent content = new ClipboardContent();
        content.putString(string);
        clipboard.setContent((Map)content);
        this.setPrimaryClipboardContent(content);
    }

    public void setContent(List<BibEntry> entries, BibEntryTypesManager entryTypesManager) throws IOException {
        String serializedEntries = this.serializeEntries(entries, entryTypesManager);
        this.setContent(serializedEntries);
    }

    public void setContent(List<BibEntry> entries, BibEntryTypesManager entryTypesManager, List<BibtexString> stringConstants) throws IOException {
        StringBuilder builder = new StringBuilder();
        stringConstants.forEach(strConst -> builder.append(strConst.getParsedSerialization() == null ? "" : strConst.getParsedSerialization()));
        String serializedEntries = this.serializeEntries(entries, entryTypesManager);
        builder.append(serializedEntries);
        this.setContent(builder.toString());
    }

    private String serializeEntries(List<BibEntry> entries, BibEntryTypesManager entryTypesManager) throws IOException {
        PreferencesService preferencesService = (PreferencesService)Injector.instantiateModelOrService(PreferencesService.class);
        BibEntryWriter writer = new BibEntryWriter(new FieldWriter(preferencesService.getFieldPreferences()), entryTypesManager);
        return writer.serializeAll(entries, BibDatabaseMode.BIBTEX);
    }
}

