/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.concurrent.Task;
import javafx.print.PrinterJob;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.util.StringConverter;
import org.jabref.gui.StateManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.l10n.Localization;

public interface DialogService {
    public <T> Optional<T> showChoiceDialogAndWait(String var1, String var2, String var3, T var4, Collection<T> var5);

    default public <T> Optional<T> showChoiceDialogAndWait(String title, String content, String okButtonLabel, Collection<T> choices) {
        return this.showChoiceDialogAndWait(title, content, okButtonLabel, null, choices);
    }

    public <T> Optional<T> showEditableChoiceDialogAndWait(String var1, String var2, String var3, T var4, Collection<T> var5, StringConverter<T> var6);

    default public <T> Optional<T> showEditableChoiceDialogAndWait(String title, String content, String okButtonLabel, Collection<T> choices, StringConverter<T> converter) {
        return this.showEditableChoiceDialogAndWait(title, content, okButtonLabel, null, choices, converter);
    }

    public Optional<String> showInputDialogAndWait(String var1, String var2);

    public Optional<String> showInputDialogWithDefaultAndWait(String var1, String var2, String var3);

    public void showInformationDialogAndWait(String var1, String var2);

    public void showWarningDialogAndWait(String var1, String var2);

    public void showErrorDialogAndWait(String var1, String var2);

    public void showErrorDialogAndWait(String var1, Throwable var2);

    default public void showErrorDialogAndWait(Exception exception) {
        this.showErrorDialogAndWait(Localization.lang("Unhandled exception occurred.", new Object[0]), exception);
    }

    public void showErrorDialogAndWait(String var1, String var2, Throwable var3);

    public void showErrorDialogAndWait(String var1);

    public boolean showConfirmationDialogAndWait(String var1, String var2);

    public boolean showConfirmationDialogAndWait(String var1, String var2, String var3);

    public boolean showConfirmationDialogAndWait(String var1, String var2, String var3, String var4);

    public boolean showConfirmationDialogWithOptOutAndWait(String var1, String var2, String var3, Consumer<Boolean> var4);

    public boolean showConfirmationDialogWithOptOutAndWait(String var1, String var2, String var3, String var4, String var5, Consumer<Boolean> var6);

    public Optional<String> showPasswordDialogAndWait(String var1, String var2, String var3);

    public void showCustomDialog(BaseDialog<?> var1);

    public Optional<ButtonType> showCustomButtonDialogAndWait(Alert.AlertType var1, String var2, String var3, ButtonType ... var4);

    public Optional<ButtonType> showCustomDialogAndWait(String var1, DialogPane var2, ButtonType ... var3);

    public <R> Optional<R> showCustomDialogAndWait(Dialog<R> var1);

    public <V> void showProgressDialog(String var1, String var2, Task<V> var3);

    public <V> void showProgressDialogAndWait(String var1, String var2, Task<V> var3);

    public <V> Optional<ButtonType> showBackgroundProgressDialogAndWait(String var1, String var2, StateManager var3);

    public void notify(String var1);

    public Optional<Path> showFileSaveDialog(FileDialogConfiguration var1);

    public Optional<Path> showFileOpenDialog(FileDialogConfiguration var1);

    public List<Path> showFileOpenDialogAndGetMultipleFiles(FileDialogConfiguration var1);

    public Optional<Path> showDirectorySelectionDialog(DirectoryDialogConfiguration var1);

    public boolean showPrintDialog(PrinterJob var1);

    public Optional<Path> showFileOpenFromArchiveDialog(Path var1) throws IOException;
}

