/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import com.google.common.eventbus.Subscribe;
import org.jabref.model.entry.event.EntriesEventSource;
import org.jabref.model.entry.event.EntryChangedEvent;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

class UpdateTimestampListener {
    private final PreferencesService preferencesService;

    UpdateTimestampListener(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    @Subscribe
    public void listen(EntryChangedEvent event) {
        if (this.preferencesService.getTimestampPreferences().shouldAddModificationDate() && event.getEntriesEventSource() != EntriesEventSource.CLEANUP_TIMESTAMP) {
            event.getBibEntry().setField(StandardField.MODIFICATIONDATE, this.preferencesService.getTimestampPreferences().now());
        }
    }
}

