/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autosaveandbackup;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jabref.logic.util.CoarseChangeFilter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.AutosaveEvent;
import org.jabref.model.database.event.BibDatabaseContextChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutosaveManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutosaveManager.class);
    private static final int DELAY_BETWEEN_AUTOSAVE_ATTEMPTS_IN_SECONDS = 31;
    private static Set<AutosaveManager> runningInstances = new HashSet<AutosaveManager>();
    private final BibDatabaseContext bibDatabaseContext;
    private final EventBus eventBus;
    private final CoarseChangeFilter changeFilter;
    private final ScheduledThreadPoolExecutor executor;
    private boolean needsSave = false;

    private AutosaveManager(BibDatabaseContext bibDatabaseContext) {
        this.bibDatabaseContext = bibDatabaseContext;
        this.eventBus = new EventBus();
        this.changeFilter = new CoarseChangeFilter(bibDatabaseContext);
        this.changeFilter.registerListener(this);
        this.executor = new ScheduledThreadPoolExecutor(2);
        this.executor.scheduleAtFixedRate(() -> {
            if (this.needsSave) {
                this.eventBus.post((Object)new AutosaveEvent());
                this.needsSave = false;
            }
        }, 31L, 31L, TimeUnit.SECONDS);
    }

    @Subscribe
    public void listen(BibDatabaseContextChangedEvent event) {
        if (!event.isFilteredOut()) {
            this.needsSave = true;
        }
    }

    private void shutdown() {
        this.changeFilter.unregisterListener(this);
        this.changeFilter.shutdown();
        this.executor.shutdown();
    }

    public static AutosaveManager start(BibDatabaseContext bibDatabaseContext) {
        AutosaveManager autosaveManager = new AutosaveManager(bibDatabaseContext);
        runningInstances.add(autosaveManager);
        return autosaveManager;
    }

    public static void shutdown(BibDatabaseContext bibDatabaseContext) {
        runningInstances.stream().filter(instance -> instance.bibDatabaseContext == bibDatabaseContext).findAny().ifPresent(instance -> {
            instance.shutdown();
            runningInstances.remove(instance);
        });
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }

    public void unregisterListener(Object listener) {
        try {
            this.eventBus.unregister(listener);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Problem unregistering", (Throwable)e);
        }
    }
}

