/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.auximport;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.auximport.FromAuxDialogViewModel;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.PreferencesService;

public class FromAuxDialog
extends BaseDialog<Void> {
    @FXML
    private ButtonType generateButtonType;
    @FXML
    private TextField auxFileField;
    @FXML
    private ListView<String> notFoundList;
    @FXML
    private TextArea statusInfos;
    @FXML
    private ComboBox<BibDatabaseContext> libraryListView;
    @Inject
    private PreferencesService preferences;
    @Inject
    private DialogService dialogService;
    @Inject
    private ThemeManager themeManager;
    @Inject
    private StateManager stateManager;
    private final LibraryTabContainer tabContainer;
    private FromAuxDialogViewModel viewModel;

    public FromAuxDialog(LibraryTabContainer tabContainer) {
        this.tabContainer = tabContainer;
        this.setTitle(Localization.lang("AUX file import", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        Button generateButton = (Button)this.getDialogPane().lookupButton(this.generateButtonType);
        generateButton.disableProperty().bind((ObservableValue)this.viewModel.parseFailedProperty());
        generateButton.defaultButtonProperty().bind((ObservableValue)generateButton.disableProperty().not());
        this.setResultConverter(button -> {
            if (button == this.generateButtonType) {
                this.viewModel.addResultToTabContainer();
            }
            return null;
        });
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    @FXML
    private void initialize() {
        this.viewModel = new FromAuxDialogViewModel(this.tabContainer, this.dialogService, this.preferences, this.stateManager);
        this.auxFileField.textProperty().bindBidirectional((Property)this.viewModel.auxFileProperty());
        this.statusInfos.textProperty().bindBidirectional((Property)this.viewModel.statusTextProperty());
        this.notFoundList.itemsProperty().bind(this.viewModel.notFoundList());
        this.libraryListView.setEditable(false);
        this.libraryListView.itemsProperty().bind(this.viewModel.librariesProperty());
        this.libraryListView.valueProperty().bindBidirectional(this.viewModel.selectedLibraryProperty());
        new ViewModelListCellFactory().withText(this.viewModel::getDatabaseName).install(this.libraryListView);
        EasyBind.listen((ObservableValue)this.libraryListView.getSelectionModel().selectedItemProperty(), (obs, oldValue, newValue) -> this.parseActionPerformed());
    }

    @FXML
    private void parseActionPerformed() {
        this.viewModel.parse();
    }

    @FXML
    private void browseButtonClicked() {
        this.viewModel.browse();
    }
}

