/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.auximport;

import com.tobiasdiez.easybind.EasyBind;
import java.nio.file.Path;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.auximport.AuxParserResultViewModel;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.auxparser.AuxParserResult;
import org.jabref.logic.auxparser.DefaultAuxParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.DatabaseLocation;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.PreferencesService;

public class FromAuxDialogViewModel {
    private final BooleanProperty parseFailedProperty = new SimpleBooleanProperty(false);
    private final StringProperty auxFileProperty = new SimpleStringProperty();
    private final StringProperty statusTextProperty = new SimpleStringProperty();
    private final ListProperty<String> notFoundList = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<BibDatabaseContext> librariesProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<BibDatabaseContext> selectedLibraryProperty = new SimpleObjectProperty();
    private final LibraryTabContainer tabContainer;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private AuxParserResult auxParserResult;

    public FromAuxDialogViewModel(LibraryTabContainer tabContainer, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager) {
        this.tabContainer = tabContainer;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.librariesProperty.setAll(stateManager.getOpenDatabases());
        this.selectedLibraryProperty.set((Object)tabContainer.getCurrentLibraryTab().getBibDatabaseContext());
        EasyBind.listen(this.selectedLibraryProperty, (obs, oldValue, newValue) -> {
            if (this.auxParserResult != null) {
                this.parse();
            }
        });
    }

    public String getDatabaseName(BibDatabaseContext databaseContext) {
        Optional<String> dbOpt = Optional.empty();
        if (databaseContext.getDatabasePath().isPresent()) {
            dbOpt = FileUtil.getUniquePathFragment(this.stateManager.collectAllDatabasePaths(), databaseContext.getDatabasePath().get());
        }
        if (databaseContext.getLocation() == DatabaseLocation.SHARED) {
            return databaseContext.getDBMSSynchronizer().getDBName() + " [" + Localization.lang("shared", new Object[0]) + "]";
        }
        return dbOpt.orElse(Localization.lang("untitled", new Object[0]));
    }

    public void browse() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.AUX).withDefaultExtension(StandardFileType.AUX).withInitialDirectory(this.preferencesService.getFilePreferences().getWorkingDirectory()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(file -> this.auxFileProperty.setValue(file.toAbsolutePath().toString()));
    }

    public void parse() {
        this.parseFailedProperty.set(false);
        this.notFoundList.clear();
        this.statusTextProperty.setValue("");
        BibDatabase referenceDatabase = ((BibDatabaseContext)this.selectedLibraryProperty.get()).getDatabase();
        String auxName = (String)this.auxFileProperty.get();
        if (auxName != null && referenceDatabase != null && !auxName.isEmpty()) {
            DefaultAuxParser auxParser = new DefaultAuxParser(referenceDatabase);
            this.auxParserResult = auxParser.parse(Path.of(auxName, new String[0]));
            this.notFoundList.setAll(this.auxParserResult.getUnresolvedKeys());
            this.statusTextProperty.set((Object)new AuxParserResultViewModel(this.auxParserResult).getInformation(false));
            if (!this.auxParserResult.getGeneratedBibDatabase().hasEntries()) {
                this.statusTextProperty.set((Object)((String)this.statusTextProperty.get() + "\n" + Localization.lang("empty library", new Object[0])));
                this.parseFailedProperty.set(true);
            }
        } else {
            this.parseFailedProperty.set(true);
        }
    }

    public void addResultToTabContainer() {
        BibDatabaseContext context = new BibDatabaseContext(this.auxParserResult.getGeneratedBibDatabase());
        this.tabContainer.addTab(context, true);
    }

    public BooleanProperty parseFailedProperty() {
        return this.parseFailedProperty;
    }

    public StringProperty auxFileProperty() {
        return this.auxFileProperty;
    }

    public StringProperty statusTextProperty() {
        return this.statusTextProperty;
    }

    public ReadOnlyListProperty<String> notFoundList() {
        return this.notFoundList;
    }

    public ReadOnlyListProperty<BibDatabaseContext> librariesProperty() {
        return this.librariesProperty;
    }

    public ObjectProperty<BibDatabaseContext> selectedLibraryProperty() {
        return this.selectedLibraryProperty;
    }
}

