/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.bibtexextractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;

public class BibtexExtractor {
    private static final String AUTHOR_TAG = "[author_tag]";
    private static final String URL_TAG = "[url_tag]";
    private static final String YEAR_TAG = "[year_tag]";
    private static final String PAGES_TAG = "[pages_tag]";
    private static final String INITIALS_GROUP = "INITIALS";
    private static final String LASTNAME_GROUP = "LASTNAME";
    private static final Pattern URL_PATTERN = Pattern.compile("(?:^|[\\W])((ht|f)tp(s?):\\/\\/|www\\.)(([\\w\\-]+\\.)+?([\\w\\-.~]+\\/?)*[\\p{Alnum}.,%_=?&#\\-+()\\[\\]\\*$~@!:/{};']*)", 42);
    private static final Pattern YEAR_PATTERN = Pattern.compile("\\d{4}", 42);
    private static final Pattern AUTHOR_PATTERN = Pattern.compile("(?<LASTNAME>\\p{Lu}\\w+),?\\s(?<INITIALS>(\\p{Lu}\\.\\s){1,2})\\s*(and|,|\\.)*", 42);
    private static final Pattern AUTHOR_PATTERN_2 = Pattern.compile("(?<INITIALS>(\\p{Lu}\\.\\s){1,2})(?<LASTNAME>\\p{Lu}\\w+)\\s*(and|,|\\.)*", 42);
    private static final Pattern PAGES_PATTERN = Pattern.compile("(p.)?\\s?\\d+(-\\d+)?", 42);
    private final List<String> urls = new ArrayList<String>();
    private final List<String> authors = new ArrayList<String>();
    private String year = "";
    private String pages = "";
    private String title = "";
    private boolean isArticle = true;
    private String journalOrPublisher = "";

    public BibEntry extract(String input) {
        String inputWithoutUrls = this.findUrls(input);
        String inputWithoutAuthors = this.findAuthors(inputWithoutUrls);
        String inputWithoutYear = this.findYear(inputWithoutAuthors);
        String inputWithoutPages = this.findPages(inputWithoutYear);
        String nonParsed = this.findParts(inputWithoutPages);
        return this.generateEntity(nonParsed);
    }

    private BibEntry generateEntity(String input) {
        StandardEntryType type = this.isArticle ? StandardEntryType.Article : StandardEntryType.Book;
        BibEntry extractedEntity = new BibEntry(type);
        extractedEntity.setField(StandardField.AUTHOR, String.join((CharSequence)" and ", this.authors));
        extractedEntity.setField(StandardField.URL, String.join((CharSequence)", ", this.urls));
        extractedEntity.setField(StandardField.YEAR, this.year);
        extractedEntity.setField(StandardField.PAGES, this.pages);
        extractedEntity.setField(StandardField.TITLE, this.title);
        if (this.isArticle) {
            extractedEntity.setField(StandardField.JOURNAL, this.journalOrPublisher);
        } else {
            extractedEntity.setField(StandardField.PUBLISHER, this.journalOrPublisher);
        }
        extractedEntity.setField(StandardField.COMMENT, input);
        return extractedEntity;
    }

    private String findUrls(String input) {
        Matcher matcher = URL_PATTERN.matcher(input);
        while (matcher.find()) {
            this.urls.add(input.substring(matcher.start(1), matcher.end()));
        }
        return this.fixSpaces(matcher.replaceAll(URL_TAG));
    }

    private String findYear(String input) {
        Matcher matcher = YEAR_PATTERN.matcher(input);
        while (matcher.find()) {
            String yearCandidate = input.substring(matcher.start(), matcher.end());
            int intYearCandidate = Integer.parseInt(yearCandidate);
            if (intYearCandidate <= 1700 || intYearCandidate > Calendar.getInstance().get(1)) continue;
            this.year = yearCandidate;
            return this.fixSpaces(input.replace(this.year, YEAR_TAG));
        }
        return input;
    }

    private String findAuthors(String input) {
        String currentInput = this.findAuthorsByPattern(input, AUTHOR_PATTERN);
        return this.findAuthorsByPattern(currentInput, AUTHOR_PATTERN_2);
    }

    private String findAuthorsByPattern(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            this.authors.add(this.GenerateAuthor(matcher.group(LASTNAME_GROUP), matcher.group(INITIALS_GROUP)));
        }
        return this.fixSpaces(matcher.replaceAll(AUTHOR_TAG));
    }

    private String GenerateAuthor(String lastName, String initials) {
        return lastName + ", " + initials;
    }

    private String findPages(String input) {
        Matcher matcher = PAGES_PATTERN.matcher(input);
        if (matcher.find()) {
            this.pages = input.substring(matcher.start(), matcher.end());
        }
        return this.fixSpaces(matcher.replaceFirst(PAGES_TAG));
    }

    private String fixSpaces(String input) {
        return input.replaceAll("[,.!?;:]", "$0 ").replaceAll("\\p{Lt}", " $0").replaceAll("\\s+", " ").trim();
    }

    private String findParts(String input) {
        String part;
        ArrayList<String> lastParts = new ArrayList<String>();
        int afterAuthorsIndex = input.lastIndexOf(AUTHOR_TAG);
        if (afterAuthorsIndex == -1) {
            return input;
        }
        afterAuthorsIndex += AUTHOR_TAG.length();
        int delimiterIndex = input.lastIndexOf("//");
        if (delimiterIndex != -1) {
            lastParts.add(input.substring(afterAuthorsIndex, delimiterIndex).replace(YEAR_TAG, "").replace(PAGES_TAG, ""));
            lastParts.addAll(Arrays.asList(input.substring(delimiterIndex + 2).split(",|\\.")));
        } else {
            lastParts.addAll(Arrays.asList(input.substring(afterAuthorsIndex).split(",|\\.")));
        }
        int nonDigitParts = 0;
        Iterator iterator = lastParts.iterator();
        while (iterator.hasNext() && !(part = (String)iterator.next()).matches(".*\\d.*")) {
            ++nonDigitParts;
        }
        if (nonDigitParts > 0) {
            this.title = (String)lastParts.getFirst();
        }
        if (nonDigitParts > 1) {
            this.journalOrPublisher = (String)lastParts.get(1);
        }
        if (nonDigitParts > 2) {
            this.isArticle = false;
        }
        return this.fixSpaces(input);
    }
}

