/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab.entrydelete;

import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeResolverFactory;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableRemoveEntries;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;

public final class EntryDelete
extends DatabaseChange {
    private final BibEntry deletedEntry;

    public EntryDelete(BibEntry deletedEntry, BibDatabaseContext databaseContext, DatabaseChangeResolverFactory databaseChangeResolverFactory) {
        super(databaseContext, databaseChangeResolverFactory);
        this.deletedEntry = deletedEntry;
        this.setChangeName(deletedEntry.getCitationKey().map(key -> Localization.lang("Deleted entry '%0'", key)).orElse(Localization.lang("Deleted entry", new Object[0])));
    }

    @Override
    public void applyChange(NamedCompound undoEdit) {
        this.databaseContext.getDatabase().removeEntry(this.deletedEntry);
        undoEdit.addEdit(new UndoableRemoveEntries(this.databaseContext.getDatabase(), this.deletedEntry));
    }

    public BibEntry getDeletedEntry() {
        return this.deletedEntry;
    }
}

