/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab.groupchange;

import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeResolverFactory;
import org.jabref.gui.groups.GroupTreeNodeViewModel;
import org.jabref.gui.groups.UndoableModifySubtree;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.logic.bibtex.comparator.GroupDiff;
import org.jabref.logic.groups.DefaultGroupsFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.groups.GroupTreeNode;

public final class GroupChange
extends DatabaseChange {
    private final GroupDiff groupDiff;

    public GroupChange(GroupDiff groupDiff, BibDatabaseContext databaseContext, DatabaseChangeResolverFactory databaseChangeResolverFactory) {
        super(databaseContext, databaseChangeResolverFactory);
        this.groupDiff = groupDiff;
        this.setChangeName(groupDiff.getOriginalGroupRoot() == null ? Localization.lang("Removed all groups", new Object[0]) : Localization.lang("Modified groups tree", new Object[0]));
    }

    @Override
    public void applyChange(NamedCompound undoEdit) {
        GroupTreeNode oldRoot = this.groupDiff.getOriginalGroupRoot();
        GroupTreeNode newRoot = this.groupDiff.getNewGroupRoot();
        GroupTreeNode root = this.databaseContext.getMetaData().getGroups().orElseGet(() -> {
            GroupTreeNode groupTreeNode = new GroupTreeNode(DefaultGroupsFactory.getAllEntriesGroup());
            this.databaseContext.getMetaData().setGroups(groupTreeNode);
            return groupTreeNode;
        });
        UndoableModifySubtree undo = new UndoableModifySubtree(new GroupTreeNodeViewModel(this.databaseContext.getMetaData().getGroups().orElse(null)), new GroupTreeNodeViewModel(root), Localization.lang("Modified groups", new Object[0]));
        root.removeAllChildren();
        if (newRoot == null) {
            root.setGroup(DefaultGroupsFactory.getAllEntriesGroup(), false, false, null);
        } else {
            root.setGroup(newRoot.getGroup(), false, false, null);
            for (GroupTreeNode child : newRoot.getChildren()) {
                ((GroupTreeNode)child.copySubtree()).moveTo(root);
            }
        }
        undoEdit.addEdit(undo);
    }

    public GroupDiff getGroupDiff() {
        return this.groupDiff;
    }
}

