/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.collab.metedatachange;

import org.jabref.gui.collab.DatabaseChange;
import org.jabref.gui.collab.DatabaseChangeResolverFactory;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.logic.bibtex.comparator.MetaDataDiff;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;

public final class MetadataChange
extends DatabaseChange {
    private final MetaDataDiff metaDataDiff;

    public MetadataChange(MetaDataDiff metaDataDiff, BibDatabaseContext databaseContext, DatabaseChangeResolverFactory databaseChangeResolverFactory) {
        super(databaseContext, databaseChangeResolverFactory);
        this.metaDataDiff = metaDataDiff;
        this.setChangeName(Localization.lang("Metadata change", new Object[0]));
    }

    @Override
    public void applyChange(NamedCompound undoEdit) {
        this.databaseContext.setMetaData(this.metaDataDiff.getNewMetaData());
        this.metaDataDiff.getGroupDifferences().ifPresent(groupDiff -> this.databaseContext.getMetaData().setGroups(groupDiff.getOriginalGroupRoot()));
    }

    public MetaDataDiff getMetaDataDiff() {
        return this.metaDataDiff;
    }
}

