/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.commonfxcontrols;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.Collection;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyEvent;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanelItemModel;
import org.jabref.gui.commonfxcontrols.CitationKeyPatternsPanelViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.citationkeypattern.AbstractCitationKeyPatterns;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.types.EntryType;
import org.jabref.preferences.PreferencesService;

public class CitationKeyPatternsPanel
extends TableView<CitationKeyPatternsPanelItemModel> {
    @FXML
    public TableColumn<CitationKeyPatternsPanelItemModel, EntryType> entryTypeColumn;
    @FXML
    public TableColumn<CitationKeyPatternsPanelItemModel, String> patternColumn;
    @FXML
    public TableColumn<CitationKeyPatternsPanelItemModel, EntryType> actionsColumn;
    @Inject
    private PreferencesService preferences;
    private CitationKeyPatternsPanelViewModel viewModel;
    private long lastKeyPressTime;
    private String tableSearchTerm;

    public CitationKeyPatternsPanel() {
        ViewLoader.view((Object)((Object)this)).root((Object)this).load();
    }

    @FXML
    private void initialize() {
        this.viewModel = new CitationKeyPatternsPanelViewModel(this.preferences.getCitationKeyPatternPreferences());
        this.setEditable(true);
        this.entryTypeColumn.setSortable(true);
        this.entryTypeColumn.setReorderable(false);
        this.entryTypeColumn.setCellValueFactory(cellData -> ((CitationKeyPatternsPanelItemModel)cellData.getValue()).entryType());
        new ValueTableCellFactory().withText(EntryType::getDisplayName).install(this.entryTypeColumn);
        this.setOnSort(event -> this.viewModel.patternListProperty().sort(CitationKeyPatternsPanelViewModel.defaultOnTopComparator));
        this.patternColumn.setSortable(true);
        this.patternColumn.setReorderable(false);
        this.patternColumn.setCellValueFactory(cellData -> ((CitationKeyPatternsPanelItemModel)cellData.getValue()).pattern());
        this.patternColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.patternColumn.setEditable(true);
        this.patternColumn.setOnEditCommit(event -> ((CitationKeyPatternsPanelItemModel)event.getRowValue()).setPattern((String)event.getNewValue()));
        this.actionsColumn.setSortable(false);
        this.actionsColumn.setReorderable(false);
        this.actionsColumn.setCellValueFactory(cellData -> ((CitationKeyPatternsPanelItemModel)cellData.getValue()).entryType());
        new ValueTableCellFactory().withGraphic(entryType -> IconTheme.JabRefIcons.REFRESH.getGraphicNode()).withTooltip(entryType -> Localization.lang("Reset %s to default value", new Object[0]).formatted(entryType.getDisplayName())).withOnMouseClickedEvent(item -> evt -> this.viewModel.setItemToDefaultPattern((CitationKeyPatternsPanelItemModel)this.getFocusModel().getFocusedItem())).install(this.actionsColumn);
        this.setRowFactory(item -> new HighlightTableRow());
        this.setOnKeyTyped(this::jumpToSearchKey);
        this.itemsProperty().bindBidirectional(this.viewModel.patternListProperty());
    }

    public void setValues(Collection<BibEntryType> entryTypeList, AbstractCitationKeyPatterns keyPattern) {
        this.viewModel.setValues(entryTypeList, keyPattern);
    }

    public void resetAll() {
        this.viewModel.resetAll();
    }

    public ListProperty<CitationKeyPatternsPanelItemModel> patternListProperty() {
        return this.viewModel.patternListProperty();
    }

    public ObjectProperty<CitationKeyPatternsPanelItemModel> defaultKeyPatternProperty() {
        return this.viewModel.defaultKeyPatternProperty();
    }

    private void jumpToSearchKey(KeyEvent keypressed) {
        if (keypressed.getCharacter() == null) {
            return;
        }
        this.tableSearchTerm = System.currentTimeMillis() - this.lastKeyPressTime < 1000L ? this.tableSearchTerm + keypressed.getCharacter().toLowerCase() : keypressed.getCharacter().toLowerCase();
        this.lastKeyPressTime = System.currentTimeMillis();
        this.getItems().stream().filter(item -> item.getEntryType().getName().toLowerCase().startsWith(this.tableSearchTerm)).findFirst().ifPresent(arg_0 -> ((CitationKeyPatternsPanel)this).scrollTo(arg_0));
    }

    private static class HighlightTableRow
    extends TableRow<CitationKeyPatternsPanelItemModel> {
        private HighlightTableRow() {
        }

        public void updateItem(CitationKeyPatternsPanelItemModel item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || item.getEntryType() == null) {
                this.setStyle("");
            } else if (this.isSelected()) {
                this.setStyle("-fx-background-color: -fx-selection-bar");
            } else if (item.getEntryType().getName().equals("default")) {
                this.setStyle("-fx-background-color: -fx-default-button");
            } else {
                this.setStyle("");
            }
        }
    }
}

