/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.commonfxcontrols;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.commonfxcontrols.SaveOrderConfigPanelViewModel;
import org.jabref.gui.commonfxcontrols.SortCriterionViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIconView;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class SaveOrderConfigPanel
extends VBox {
    @FXML
    private RadioButton exportInSpecifiedOrder;
    @FXML
    private RadioButton exportInTableOrder;
    @FXML
    private RadioButton exportInOriginalOrder;
    @FXML
    private GridPane sortCriterionList;
    @FXML
    private Button addButton;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private UndoManager undoManager;
    private SaveOrderConfigPanelViewModel viewModel;

    public SaveOrderConfigPanel() {
        ViewLoader.view((Object)((Object)this)).root((Object)this).load();
    }

    @FXML
    private void initialize() {
        this.viewModel = new SaveOrderConfigPanelViewModel();
        this.exportInOriginalOrder.selectedProperty().bindBidirectional((Property)this.viewModel.saveInOriginalProperty());
        this.exportInTableOrder.selectedProperty().bindBidirectional((Property)this.viewModel.saveInTableOrderProperty());
        this.exportInSpecifiedOrder.selectedProperty().bindBidirectional((Property)this.viewModel.saveInSpecifiedOrderProperty());
        this.viewModel.sortCriteriaProperty().addListener(change -> {
            while (change.next()) {
                if (change.wasReplaced()) {
                    this.clearCriterionRow(change.getFrom());
                    this.createCriterionRow((SortCriterionViewModel)change.getAddedSubList().getFirst(), change.getFrom());
                    continue;
                }
                if (change.wasAdded()) {
                    for (SortCriterionViewModel criterionViewModel : change.getAddedSubList()) {
                        int row = change.getFrom() + change.getAddedSubList().indexOf(criterionViewModel);
                        this.createCriterionRow(criterionViewModel, row);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (SortCriterionViewModel criterionViewModel : change.getRemoved()) {
                    this.clearCriterionRow(change.getFrom());
                }
            }
        });
    }

    private void createCriterionRow(SortCriterionViewModel criterionViewModel, int row) {
        this.sortCriterionList.getChildren().stream().filter(item -> GridPane.getRowIndex((Node)item) >= row).forEach(item -> {
            GridPane.setRowIndex((Node)item, (Integer)(GridPane.getRowIndex((Node)item) + 1));
            if (item instanceof Label) {
                Label label = (Label)item;
                label.setText(String.valueOf(GridPane.getRowIndex((Node)item) + 1));
            }
        });
        Label label = new Label(String.valueOf(row + 1));
        this.sortCriterionList.add((Node)label, 0, row);
        ComboBox field = new ComboBox(this.viewModel.sortableFieldsProperty());
        field.setMaxWidth(Double.MAX_VALUE);
        new ViewModelListCellFactory().withText(item -> FieldsUtil.getNameWithType(item, this.preferencesService, this.undoManager)).install(field);
        field.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        field.itemsProperty().bindBidirectional(this.viewModel.sortableFieldsProperty());
        field.valueProperty().bindBidirectional(criterionViewModel.fieldProperty());
        this.sortCriterionList.add((Node)field, 1, row);
        GridPane.getHgrow((Node)field);
        CheckBox descending = new CheckBox(Localization.lang("Descending", new Object[0]));
        descending.selectedProperty().bindBidirectional((Property)criterionViewModel.descendingProperty());
        this.sortCriterionList.add((Node)descending, 2, row);
        HBox hBox = new HBox();
        hBox.getChildren().addAll(this.createRowButtons(criterionViewModel));
        this.sortCriterionList.add((Node)hBox, 3, row);
    }

    private List<Node> createRowButtons(SortCriterionViewModel criterionViewModel) {
        Button remove = new Button("", (Node)new JabRefIconView(IconTheme.JabRefIcons.REMOVE_NOBOX));
        remove.getStyleClass().addAll((Object[])new String[]{"icon-button", "narrow"});
        remove.setPrefHeight(20.0);
        remove.setPrefWidth(20.0);
        remove.setOnAction(event -> this.removeCriterion(criterionViewModel));
        Button moveUp = new Button("", (Node)new JabRefIconView(IconTheme.JabRefIcons.LIST_MOVE_UP));
        moveUp.getStyleClass().addAll((Object[])new String[]{"icon-button", "narrow"});
        moveUp.setPrefHeight(20.0);
        moveUp.setPrefWidth(20.0);
        moveUp.setOnAction(event -> this.moveCriterionUp(criterionViewModel));
        Button moveDown = new Button("", (Node)new JabRefIconView(IconTheme.JabRefIcons.LIST_MOVE_DOWN));
        moveDown.getStyleClass().addAll((Object[])new String[]{"icon-button", "narrow"});
        moveDown.setPrefHeight(20.0);
        moveDown.setPrefWidth(20.0);
        moveDown.setOnAction(event -> this.moveCriterionDown(criterionViewModel));
        return List.of(moveUp, moveDown, remove);
    }

    private void clearCriterionRow(int row) {
        List criterionRow = this.sortCriterionList.getChildren().stream().filter(item -> GridPane.getRowIndex((Node)item) == row).collect(Collectors.toList());
        this.sortCriterionList.getChildren().removeAll(criterionRow);
        this.sortCriterionList.getChildren().stream().filter(item -> GridPane.getRowIndex((Node)item) > row).forEach(item -> {
            GridPane.setRowIndex((Node)item, (Integer)(GridPane.getRowIndex((Node)item) - 1));
            if (item instanceof Label) {
                Label label = (Label)item;
                label.setText(String.valueOf(GridPane.getRowIndex((Node)item) + 1));
            }
        });
    }

    public void setCriteriaLimit(int limit) {
        this.addButton.disableProperty().unbind();
        this.addButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.viewModel.sortCriteriaProperty().size() >= limit || !this.exportInSpecifiedOrder.selectedProperty().get(), (Observable[])new Observable[]{this.viewModel.sortCriteriaProperty().sizeProperty(), this.exportInSpecifiedOrder.selectedProperty()}));
    }

    @FXML
    public void addCriterion() {
        this.viewModel.addCriterion();
    }

    @FXML
    public void moveCriterionUp(SortCriterionViewModel criterionViewModel) {
        this.viewModel.moveCriterionUp(criterionViewModel);
    }

    @FXML
    public void moveCriterionDown(SortCriterionViewModel criterionViewModel) {
        this.viewModel.moveCriterionDown(criterionViewModel);
    }

    @FXML
    public void removeCriterion(SortCriterionViewModel criterionViewModel) {
        this.viewModel.removeCriterion(criterionViewModel);
    }

    public BooleanProperty saveInOriginalProperty() {
        return this.viewModel.saveInOriginalProperty();
    }

    public BooleanProperty saveInTableOrderProperty() {
        return this.viewModel.saveInTableOrderProperty();
    }

    public BooleanProperty saveInSpecifiedOrderProperty() {
        return this.viewModel.saveInSpecifiedOrderProperty();
    }

    public ListProperty<Field> sortableFieldsProperty() {
        return this.viewModel.sortableFieldsProperty();
    }

    public ListProperty<SortCriterionViewModel> sortCriteriaProperty() {
        return this.viewModel.sortCriteriaProperty();
    }
}

