/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.jabref.gui.StateManager;
import org.jabref.gui.documentviewer.DocumentViewModel;
import org.jabref.gui.documentviewer.DocumentViewerControl;
import org.jabref.gui.documentviewer.DocumentViewerViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.OnlyIntegerFormatter;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.PreferencesService;

public class DocumentViewerView
extends BaseDialog<Void> {
    @FXML
    private ScrollBar scrollBar;
    @FXML
    private ComboBox<LinkedFile> fileChoice;
    @FXML
    private BorderPane mainPane;
    @FXML
    private ToggleGroup toggleGroupMode;
    @FXML
    private ToggleButton modeLive;
    @FXML
    private ToggleButton modeLock;
    @FXML
    private TextField currentPage;
    @FXML
    private Label maxPages;
    @FXML
    private Button nextButton;
    @FXML
    private Button previousButton;
    @Inject
    private StateManager stateManager;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private PreferencesService preferencesService;
    private DocumentViewerControl viewer;
    private DocumentViewerViewModel viewModel;

    public DocumentViewerView() {
        this.setTitle(Localization.lang("Document viewer", new Object[0]));
        this.initModality(Modality.NONE);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
        this.getDialogPane().getChildren().removeIf(ButtonBar.class::isInstance);
    }

    @FXML
    private void initialize() {
        this.viewModel = new DocumentViewerViewModel(this.stateManager, this.preferencesService);
        this.setupViewer();
        this.setupScrollbar();
        this.setupFileChoice();
        this.setupPageControls();
        this.setupModeButtons();
    }

    private void setupModeButtons() {
        this.toggleGroupMode.selectedToggleProperty().addListener((observable, oldToggle, newToggle) -> {
            if (newToggle == null) {
                oldToggle.setSelected(true);
            }
        });
        this.modeLive.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.viewModel.setLiveMode(true);
            }
        });
        this.modeLock.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.viewModel.setLiveMode(false);
            }
        });
    }

    private void setupScrollbar() {
        this.scrollBar.valueProperty().bindBidirectional((Property)this.viewer.scrollYProperty());
        this.scrollBar.maxProperty().bind((ObservableValue)this.viewer.scrollYMaxProperty());
    }

    private void setupPageControls() {
        OnlyIntegerFormatter integerFormatter = new OnlyIntegerFormatter(1);
        this.viewModel.currentPageProperty().bindBidirectional((Property)integerFormatter.valueProperty());
        this.currentPage.setTextFormatter((TextFormatter)integerFormatter);
        this.maxPages.textProperty().bind((ObservableValue)this.viewModel.maxPagesProperty().asString());
        this.previousButton.setDisable(true);
        this.viewModel.currentPageProperty().addListener((observable, oldValue, newValue) -> {
            this.nextButton.setDisable(newValue.intValue() == this.viewModel.maxPagesProperty().get());
            this.previousButton.setDisable(newValue == 1);
        });
    }

    private void setupFileChoice() {
        ViewModelListCellFactory cellFactory = new ViewModelListCellFactory().withText(LinkedFile::getLink);
        this.fileChoice.setButtonCell(cellFactory.call(null));
        this.fileChoice.setCellFactory(cellFactory);
        this.fileChoice.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.viewModel.switchToFile((LinkedFile)newValue));
        Stage stage = (Stage)this.getDialogPane().getScene().getWindow();
        this.fileChoice.itemsProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.isEmpty()) {
                stage.close();
            } else {
                this.fileChoice.getSelectionModel().selectFirst();
            }
        });
        this.fileChoice.itemsProperty().bind(this.viewModel.filesProperty());
    }

    private void setupViewer() {
        this.viewer = new DocumentViewerControl(this.taskExecutor);
        this.viewModel.currentDocumentProperty().addListener((observable, oldDocument, newDocument) -> {
            if (newDocument != null) {
                this.viewer.show((DocumentViewModel)newDocument);
            }
        });
        this.viewModel.currentPageProperty().bindBidirectional(this.viewer.currentPageProperty());
        this.mainPane.setCenter((Node)this.viewer);
    }

    public void disableLiveMode() {
        this.modeLock.setSelected(true);
    }

    public void switchToFile(LinkedFile file) {
        this.fileChoice.getSelectionModel().select((Object)file);
    }

    public void gotoPage(int pageNumber) {
        this.viewModel.showPage(pageNumber);
    }

    public void nextPage(ActionEvent actionEvent) {
        this.viewModel.showNextPage();
    }

    public void previousPage(ActionEvent actionEvent) {
        this.viewModel.showPreviousPage();
    }

    public void fitWidth(ActionEvent actionEvent) {
        this.viewer.setPageWidth(this.viewer.getWidth());
    }

    public void zoomIn(ActionEvent actionEvent) {
        this.viewer.changePageWidth(100);
    }

    public void zoomOut(ActionEvent actionEvent) {
        this.viewer.changePageWidth(-100);
    }

    public void fitSinglePage(ActionEvent actionEvent) {
        this.viewer.setPageHeight(this.viewer.getHeight());
    }
}

