/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.TextFieldTableCell;
import org.jabref.gui.edit.ManageKeywordsDisplayType;
import org.jabref.gui.edit.ManageKeywordsViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.PreferencesService;

public class ManageKeywordsDialog
extends BaseDialog<Void> {
    private final List<BibEntry> entries;
    @FXML
    private TableColumn<String, String> keywordsTableMainColumn;
    @FXML
    private TableColumn<String, Boolean> keywordsTableEditColumn;
    @FXML
    private TableColumn<String, Boolean> keywordsTableDeleteColumn;
    @FXML
    private TableView<String> keywordsTable;
    @FXML
    private ToggleGroup displayType;
    @Inject
    private PreferencesService preferences;
    private ManageKeywordsViewModel viewModel;

    public ManageKeywordsDialog(List<BibEntry> entries) {
        this.entries = entries;
        this.setTitle(Localization.lang("Manage keywords", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setResultConverter(button -> {
            if (button == ButtonType.APPLY) {
                this.viewModel.saveChanges();
            }
            return null;
        });
    }

    @FXML
    public void initialize() {
        this.viewModel = new ManageKeywordsViewModel(this.preferences.getBibEntryPreferences(), this.entries);
        this.viewModel.displayTypeProperty().bind((ObservableValue)EasyBind.map((ObservableValue)this.displayType.selectedToggleProperty(), toggle -> {
            if (toggle != null) {
                return (ManageKeywordsDisplayType)((Object)((Object)toggle.getUserData()));
            }
            return ManageKeywordsDisplayType.CONTAINED_IN_ALL_ENTRIES;
        }));
        this.keywordsTable.setItems(this.viewModel.getKeywords());
        this.keywordsTableMainColumn.setCellValueFactory(data -> BindingsHelper.constantOf((String)data.getValue()));
        this.keywordsTableMainColumn.setOnEditCommit(event -> this.viewModel.getKeywords().set(event.getTablePosition().getRow(), (Object)((String)event.getNewValue())));
        this.keywordsTableMainColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.keywordsTableEditColumn.setCellValueFactory(data -> BindingsHelper.constantOf(true));
        this.keywordsTableDeleteColumn.setCellValueFactory(data -> BindingsHelper.constantOf(true));
        new ValueTableCellFactory().withGraphic(none -> IconTheme.JabRefIcons.EDIT.getGraphicNode()).withOnMouseClickedEvent(none -> event -> this.keywordsTable.edit(this.keywordsTable.getFocusModel().getFocusedIndex(), this.keywordsTableMainColumn)).install(this.keywordsTableEditColumn);
        new ValueTableCellFactory().withGraphic(none -> IconTheme.JabRefIcons.REMOVE.getGraphicNode()).withOnMouseClickedEvent((keyword, none) -> event -> this.viewModel.removeKeyword((String)keyword)).install(this.keywordsTableDeleteColumn);
    }
}

