/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit.automaticfiededitor.editfieldcontent;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import org.jabref.gui.StateManager;
import org.jabref.gui.edit.automaticfiededitor.AbstractAutomaticFieldEditorTabView;
import org.jabref.gui.edit.automaticfiededitor.editfieldcontent.EditFieldContentViewModel;
import org.jabref.gui.util.FieldsUtil;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;

public class EditFieldContentTabView
extends AbstractAutomaticFieldEditorTabView {
    public Button appendValueButton;
    public Button clearFieldButton;
    public Button setValueButton;
    @FXML
    private ComboBox<Field> fieldComboBox;
    @FXML
    private TextField fieldValueTextField;
    @FXML
    private CheckBox overwriteFieldContentCheckBox;
    private final List<BibEntry> selectedEntries;
    private final BibDatabase database;
    private EditFieldContentViewModel viewModel;
    private final StateManager stateManager;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();

    public EditFieldContentTabView(BibDatabase database, StateManager stateManager) {
        this.selectedEntries = stateManager.getSelectedEntries();
        this.database = database;
        this.stateManager = stateManager;
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @FXML
    public void initialize() {
        this.viewModel = new EditFieldContentViewModel(this.database, this.selectedEntries, this.stateManager);
        this.fieldComboBox.setConverter(FieldsUtil.FIELD_STRING_CONVERTER);
        this.fieldComboBox.getItems().setAll(this.viewModel.getAllFields());
        this.fieldComboBox.getSelectionModel().selectFirst();
        this.fieldComboBox.valueProperty().bindBidirectional(this.viewModel.selectedFieldProperty());
        EasyBind.listen((ObservableValue)this.fieldComboBox.getEditor().textProperty(), observable -> this.fieldComboBox.commitValue());
        this.fieldValueTextField.textProperty().bindBidirectional((Property)this.viewModel.fieldValueProperty());
        this.overwriteFieldContentCheckBox.selectedProperty().bindBidirectional((Property)this.viewModel.overwriteFieldContentProperty());
        this.appendValueButton.disableProperty().bind((ObservableValue)this.viewModel.canAppendProperty().not());
        this.setValueButton.disableProperty().bind((ObservableValue)this.viewModel.fieldValidationStatus().validProperty().not());
        this.clearFieldButton.disableProperty().bind((ObservableValue)this.viewModel.fieldValidationStatus().validProperty().not());
        this.overwriteFieldContentCheckBox.disableProperty().bind((ObservableValue)this.viewModel.fieldValidationStatus().validProperty().not());
        Platform.runLater(() -> this.visualizer.initVisualization(this.viewModel.fieldValidationStatus(), this.fieldComboBox, true));
    }

    @Override
    public String getTabName() {
        return Localization.lang("Edit content", new Object[0]);
    }

    @FXML
    void appendToFieldValue() {
        this.viewModel.appendToFieldValue();
    }

    @FXML
    void clearField() {
        this.viewModel.clearSelectedField();
    }

    @FXML
    void setFieldValue() {
        this.viewModel.setFieldValue();
    }
}

