/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.EntryEditorPreferences;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.FieldNameLabel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UserSpecificCommentField;
import org.jabref.preferences.PreferencesService;

public class CommentsTab
extends FieldsEditorTab {
    public static final String NAME = "Comments";
    private final String defaultOwner;
    private final UserSpecificCommentField userSpecificCommentField;
    private final EntryEditorPreferences entryEditorPreferences;

    public CommentsTab(PreferencesService preferences, BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction, DialogService dialogService, StateManager stateManager, ThemeManager themeManager, IndexingTaskManager indexingTaskManager, TaskExecutor taskExecutor, JournalAbbreviationRepository journalAbbreviationRepository) {
        super(false, databaseContext, suggestionProviders, undoManager, undoAction, redoAction, dialogService, preferences, stateManager, themeManager, taskExecutor, journalAbbreviationRepository, indexingTaskManager);
        this.defaultOwner = preferences.getOwnerPreferences().getDefaultOwner().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "-");
        this.setText(Localization.lang(NAME, new Object[0]));
        this.setGraphic(IconTheme.JabRefIcons.COMMENT.getGraphicNode());
        this.userSpecificCommentField = new UserSpecificCommentField(this.defaultOwner);
        this.entryEditorPreferences = preferences.getEntryEditorPreferences();
    }

    @Override
    protected SequencedSet<Field> determineFieldsToShow(BibEntry entry) {
        LinkedHashSet<Field> comments = new LinkedHashSet<Field>();
        comments.add(StandardField.COMMENT);
        if (entry.hasField(this.userSpecificCommentField) || this.entryEditorPreferences.shouldShowUserCommentsFields()) {
            comments.add(this.userSpecificCommentField);
        }
        comments.addAll(entry.getFields().stream().filter(field -> field instanceof UserSpecificCommentField && !field.equals(this.userSpecificCommentField) || field.getName().toLowerCase().contains("comment")).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toCollection(LinkedHashSet::new)));
        return comments;
    }

    private void setCompressedRowLayout() {
        int numberOfComments = this.gridPane.getRowCount() - 1;
        double totalWeight = numberOfComments * 3 + 1;
        RowConstraints commentConstraint = new RowConstraints();
        commentConstraint.setVgrow(Priority.ALWAYS);
        commentConstraint.setValignment(VPos.TOP);
        double commentHeightPercent = 3.0 / totalWeight * 100.0;
        commentConstraint.setPercentHeight(commentHeightPercent);
        RowConstraints buttonConstraint = new RowConstraints();
        buttonConstraint.setVgrow(Priority.ALWAYS);
        buttonConstraint.setValignment(VPos.TOP);
        double addButtonHeightPercent = 1.0 / totalWeight * 100.0;
        buttonConstraint.setPercentHeight(addButtonHeightPercent);
        ObservableList rowConstraints = this.gridPane.getRowConstraints();
        rowConstraints.clear();
        for (int i = 1; i <= numberOfComments; ++i) {
            rowConstraints.add((Object)commentConstraint);
        }
        rowConstraints.add((Object)buttonConstraint);
    }

    @Override
    protected void setupPanel(BibEntry entry, boolean compressed) {
        super.setupPanel(entry, compressed);
        Optional<FieldEditorFX> fieldEditorForUserDefinedComment = this.editors.entrySet().stream().filter(f -> ((Field)f.getKey()).getName().contains(this.defaultOwner)).map(Map.Entry::getValue).findFirst();
        for (Map.Entry fieldEditorEntry : this.editors.entrySet()) {
            Field field = (Field)fieldEditorEntry.getKey();
            FieldEditorFX editor = (FieldEditorFX)fieldEditorEntry.getValue();
            boolean isStandardBibtexComment = field == StandardField.COMMENT;
            boolean isDefaultOwnerComment = field.equals(this.userSpecificCommentField);
            boolean shouldBeEnabled = isStandardBibtexComment || isDefaultOwnerComment;
            editor.getNode().setDisable(!shouldBeEnabled);
        }
        if (this.entryEditorPreferences.shouldShowUserCommentsFields() && !entry.hasField(this.userSpecificCommentField)) {
            Button hideDefaultOwnerCommentButton = new Button(Localization.lang("Hide user comments", new Object[0]));
            hideDefaultOwnerCommentButton.setOnAction(e -> {
                Optional<Node> labelForField = this.gridPane.getChildren().stream().filter(s -> s instanceof FieldNameLabel).filter(x -> ((FieldNameLabel)((Object)((Object)x))).getText().equals(this.userSpecificCommentField.getDisplayName())).findFirst();
                labelForField.ifPresent(label -> this.gridPane.getChildren().remove(label));
                fieldEditorForUserDefinedComment.ifPresent(f -> this.gridPane.getChildren().remove((Object)f.getNode()));
                this.editors.remove(this.userSpecificCommentField);
                this.entryEditorPreferences.setShowUserCommentsFields(false);
                this.setupPanel(entry, false);
            });
            this.gridPane.add((Node)hideDefaultOwnerCommentButton, 1, this.gridPane.getRowCount(), 2, 1);
            this.setCompressedRowLayout();
        }
    }
}

