/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.citationrelationtab;

import java.util.List;
import org.jabref.gui.entryeditor.citationrelationtab.BibEntryRelationsCache;
import org.jabref.gui.entryeditor.citationrelationtab.semanticscholar.SemanticScholarFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibEntryRelationsRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(BibEntryRelationsRepository.class);
    private final SemanticScholarFetcher fetcher;
    private final BibEntryRelationsCache cache;

    public BibEntryRelationsRepository(SemanticScholarFetcher fetcher, BibEntryRelationsCache cache) {
        this.fetcher = fetcher;
        this.cache = cache;
    }

    public List<BibEntry> getCitations(BibEntry entry) {
        if (this.needToRefreshCitations(entry)) {
            this.forceRefreshCitations(entry);
        }
        return this.cache.getCitations(entry);
    }

    public List<BibEntry> getReferences(BibEntry entry) {
        if (this.needToRefreshReferences(entry)) {
            List<BibEntry> references;
            try {
                references = this.fetcher.searchCiting(entry);
            }
            catch (FetcherException e) {
                LOGGER.error("Error while fetching references", (Throwable)e);
                references = List.of();
            }
            this.cache.cacheOrMergeReferences(entry, references);
        }
        return this.cache.getReferences(entry);
    }

    public void forceRefreshCitations(BibEntry entry) {
        try {
            List<BibEntry> citations = this.fetcher.searchCitedBy(entry);
            this.cache.cacheOrMergeCitations(entry, citations);
        }
        catch (FetcherException e) {
            LOGGER.error("Error while fetching citations", (Throwable)e);
        }
    }

    public boolean needToRefreshCitations(BibEntry entry) {
        return !this.cache.citationsCached(entry);
    }

    public boolean needToRefreshReferences(BibEntry entry) {
        return !this.cache.referencesCached(entry);
    }

    public void forceRefreshReferences(BibEntry entry) {
        List<BibEntry> references;
        try {
            references = this.fetcher.searchCiting(entry);
        }
        catch (FetcherException e) {
            LOGGER.error("Error while fetching references", (Throwable)e);
            references = List.of();
        }
        this.cache.cacheOrMergeReferences(entry, references);
    }
}

