/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.citationrelationtab;

import java.util.EnumSet;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.TextFlowLimited;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;

public class BibEntryView {
    public static Node getEntryNode(BibEntry entry) {
        Node entryType = BibEntryView.getIcon(entry.getType()).getGraphicNode();
        entryType.getStyleClass().add((Object)"type");
        Label authors = new Label(entry.getFieldOrAliasLatexFree(StandardField.AUTHOR).orElse(""));
        authors.getStyleClass().add((Object)"authors");
        authors.setWrapText(true);
        Label title = new Label(entry.getFieldOrAliasLatexFree(StandardField.TITLE).orElse(""));
        title.getStyleClass().add((Object)"title");
        title.setWrapText(true);
        Label year = new Label(entry.getFieldOrAliasLatexFree(StandardField.YEAR).orElse(""));
        year.getStyleClass().add((Object)"year");
        Label journal = new Label(entry.getFieldOrAliasLatexFree(StandardField.JOURNAL).orElse(""));
        journal.getStyleClass().add((Object)"journal");
        VBox entryContainer = new VBox(new Node[]{new HBox(10.0, new Node[]{entryType, title}), new HBox(5.0, new Node[]{year, journal}), authors});
        entry.getFieldOrAliasLatexFree(StandardField.ABSTRACT).ifPresent(summaryText -> {
            TextFlowLimited summary = new TextFlowLimited(new Text(summaryText));
            summary.getStyleClass().add((Object)"summary");
            entryContainer.getChildren().add((Object)summary);
        });
        entryContainer.getStyleClass().add((Object)"bibEntry");
        return entryContainer;
    }

    private static IconTheme.JabRefIcons getIcon(EntryType type) {
        EnumSet<StandardEntryType> crossRefTypes = EnumSet.of(StandardEntryType.InBook, StandardEntryType.InProceedings, StandardEntryType.InCollection);
        if (type == StandardEntryType.Book) {
            return IconTheme.JabRefIcons.BOOK;
        }
        if (crossRefTypes.contains(type)) {
            return IconTheme.JabRefIcons.OPEN_LINK;
        }
        return IconTheme.JabRefIcons.ARTICLE;
    }
}

