/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entrytype;

import com.airhacks.afterburner.injection.Injector;
import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import javafx.stage.Screen;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.entrytype.EntryTypeViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.importer.IdBasedFetcher;
import org.jabref.logic.importer.WebFetcher;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.types.BiblatexAPAEntryTypeDefinitions;
import org.jabref.model.entry.types.BiblatexEntryTypeDefinitions;
import org.jabref.model.entry.types.BiblatexSoftwareEntryTypeDefinitions;
import org.jabref.model.entry.types.BibtexEntryTypeDefinitions;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryTypeDefinitions;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class EntryTypeView
extends BaseDialog<EntryType> {
    @Inject
    private StateManager stateManager;
    @Inject
    private TaskExecutor taskExecutor;
    @Inject
    private FileUpdateMonitor fileUpdateMonitor;
    @FXML
    private ButtonType generateButton;
    @FXML
    private TextField idTextField;
    @FXML
    private ComboBox<IdBasedFetcher> idBasedFetchers;
    @FXML
    private FlowPane recommendedEntriesPane;
    @FXML
    private FlowPane otherEntriesPane;
    @FXML
    private FlowPane customPane;
    @FXML
    private TitledPane recommendedEntriesTitlePane;
    @FXML
    private TitledPane otherEntriesTitlePane;
    @FXML
    private TitledPane customTitlePane;
    private final LibraryTab libraryTab;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private EntryType type;
    private EntryTypeViewModel viewModel;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();

    public EntryTypeView(LibraryTab libraryTab, DialogService dialogService, PreferencesService preferences) {
        this.libraryTab = libraryTab;
        this.dialogService = dialogService;
        this.preferencesService = preferences;
        this.setTitle(Localization.lang("Select entry type", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.generateButton, this.getDialogPane(), event -> this.viewModel.runFetcherWorker());
        this.setOnCloseRequest(e -> this.viewModel.cancelFetcherWorker());
        this.setResultConverter(button -> this.type);
        Button btnGenerate = (Button)this.getDialogPane().lookupButton(this.generateButton);
        btnGenerate.getStyleClass().add((Object)"customGenerateButton");
        btnGenerate.textProperty().bind((ObservableValue)EasyBind.map((ObservableValue)this.viewModel.searchingProperty(), searching -> searching != false ? Localization.lang("Searching...", new Object[0]) : Localization.lang("Generate", new Object[0])));
        btnGenerate.disableProperty().bind((ObservableValue)this.viewModel.idFieldValidationStatus().validProperty().not().or((ObservableBooleanValue)this.viewModel.searchingProperty()));
        EasyBind.subscribe((ObservableValue)this.viewModel.searchSuccesfulProperty(), isSuccessful -> {
            if (isSuccessful.booleanValue()) {
                this.setEntryTypeForReturnAndClose(Optional.empty());
            }
        });
    }

    private void addEntriesToPane(FlowPane pane, Collection<? extends BibEntryType> entryTypes) {
        for (BibEntryType bibEntryType : entryTypes) {
            Button entryButton = new Button(bibEntryType.getType().getDisplayName());
            entryButton.setUserData((Object)bibEntryType);
            entryButton.setOnAction(event -> this.setEntryTypeForReturnAndClose(Optional.of(entryType)));
            pane.getChildren().add((Object)entryButton);
            EntryType selectedType = bibEntryType.getType();
            String description = EntryTypeView.getDescription(selectedType);
            if (!StringUtil.isNotBlank(description)) continue;
            Screen currentScreen = Screen.getPrimary();
            double maxWidth = currentScreen.getBounds().getWidth();
            Tooltip tooltip = new Tooltip(description);
            tooltip.setMaxWidth(maxWidth * 2.0 / 3.0);
            tooltip.setWrapText(true);
            entryButton.setTooltip(tooltip);
        }
    }

    @FXML
    public void initialize() {
        List otherEntries;
        List<BibEntryType> recommendedEntries;
        this.visualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        this.viewModel = new EntryTypeViewModel(this.preferencesService, this.libraryTab, this.dialogService, this.stateManager, this.taskExecutor, this.fileUpdateMonitor);
        this.idBasedFetchers.itemsProperty().bind(this.viewModel.fetcherItemsProperty());
        this.idTextField.textProperty().bindBidirectional((Property)this.viewModel.idTextProperty());
        this.idBasedFetchers.valueProperty().bindBidirectional(this.viewModel.selectedItemProperty());
        EasyBind.subscribe((ObservableValue)this.viewModel.getFocusAndSelectAllProperty(), evt -> {
            if (evt.booleanValue()) {
                this.idTextField.requestFocus();
                this.idTextField.selectAll();
            }
        });
        new ViewModelListCellFactory().withText(WebFetcher::getName).install(this.idBasedFetchers);
        this.recommendedEntriesTitlePane.managedProperty().bind((ObservableValue)this.recommendedEntriesTitlePane.visibleProperty());
        this.otherEntriesTitlePane.managedProperty().bind((ObservableValue)this.otherEntriesTitlePane.visibleProperty());
        this.customTitlePane.managedProperty().bind((ObservableValue)this.customTitlePane.visibleProperty());
        this.otherEntriesTitlePane.expandedProperty().addListener((obs, wasExpanded, isNowExpanded) -> {
            if (isNowExpanded.booleanValue()) {
                this.setHeight(this.getHeight() + this.otherEntriesPane.getHeight());
            } else {
                this.setHeight(this.getHeight() - this.otherEntriesPane.getHeight());
            }
        });
        boolean isBiblatexMode = this.libraryTab.getBibDatabaseContext().isBiblatexMode();
        if (isBiblatexMode) {
            recommendedEntries = BiblatexEntryTypeDefinitions.RECOMMENDED;
            otherEntries = BiblatexEntryTypeDefinitions.ALL.stream().filter(e -> !recommendedEntries.contains(e)).collect(Collectors.toList());
            otherEntries.addAll(BiblatexSoftwareEntryTypeDefinitions.ALL);
            otherEntries.addAll(BiblatexAPAEntryTypeDefinitions.ALL);
        } else {
            recommendedEntries = BibtexEntryTypeDefinitions.RECOMMENDED;
            otherEntries = BibtexEntryTypeDefinitions.ALL.stream().filter(e -> !recommendedEntries.contains(e)).collect(Collectors.toList());
            otherEntries.addAll(IEEETranEntryTypeDefinitions.ALL);
        }
        this.addEntriesToPane(this.recommendedEntriesPane, recommendedEntries);
        this.addEntriesToPane(this.otherEntriesPane, otherEntries);
        BibDatabaseMode customTypeDatabaseMode = isBiblatexMode ? BibDatabaseMode.BIBLATEX : BibDatabaseMode.BIBTEX;
        BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        List<BibEntryType> customTypes = entryTypesManager.getAllCustomTypes(customTypeDatabaseMode);
        if (customTypes.isEmpty()) {
            this.customTitlePane.setVisible(false);
        } else {
            this.addEntriesToPane(this.customPane, customTypes);
        }
        this.viewModel.idTextProperty().addListener((obs, oldValue, newValue) -> this.visualizer.initVisualization(this.viewModel.idFieldValidationStatus(), (Control)this.idTextField, true));
        Platform.runLater(() -> this.idTextField.requestFocus());
    }

    public EntryType getChoice() {
        return this.type;
    }

    @FXML
    private void runFetcherWorker(Event event) {
        this.viewModel.runFetcherWorker();
    }

    @FXML
    private void focusTextField(Event event) {
        this.idTextField.requestFocus();
        this.idTextField.selectAll();
    }

    private void setEntryTypeForReturnAndClose(Optional<BibEntryType> entryType) {
        this.type = entryType.map(BibEntryType::getType).orElse(null);
        this.viewModel.stopFetching();
        this.stateManager.clearSearchQuery();
        this.close();
    }

    public static String getDescription(EntryType selectedType) {
        if (selectedType instanceof StandardEntryType) {
            StandardEntryType entryType = (StandardEntryType)selectedType;
            switch (entryType) {
                case Article: {
                    return Localization.lang("An article in a journal, magazine, newspaper, or other periodical which forms a self-contained unit with its own title.", new Object[0]);
                }
                case Book: {
                    return Localization.lang("A single-volume book with one or more authors where the authors share credit for the work as a whole.", new Object[0]);
                }
                case Booklet: {
                    return Localization.lang("A book-like work without a formal publisher or sponsoring institution.", new Object[0]);
                }
                case Collection: {
                    return Localization.lang("A single-volume collection with multiple, self-contained contributions by distinct authors which have their own title. The work as a whole has no overall author but it will usually have an editor.", new Object[0]);
                }
                case Conference: {
                    return Localization.lang("A legacy alias for \"InProceedings\".", new Object[0]);
                }
                case InBook: {
                    return Localization.lang("A part of a book which forms a self-contained unit with its own title.", new Object[0]);
                }
                case InCollection: {
                    return Localization.lang("A contribution to a collection which forms a self-contained unit with a distinct author and title.", new Object[0]);
                }
                case InProceedings: {
                    return Localization.lang("An article in a conference proceedings.", new Object[0]);
                }
                case Manual: {
                    return Localization.lang("Technical or other documentation, not necessarily in printed form.", new Object[0]);
                }
                case MastersThesis: {
                    return Localization.lang("Similar to \"Thesis\" except that the type field is optional and defaults to the localised term  Master's thesis.", new Object[0]);
                }
                case Misc: {
                    return Localization.lang("A fallback type for entries which do not fit into any other category.", new Object[0]);
                }
                case PhdThesis: {
                    return Localization.lang("Similar to \"Thesis\" except that the type field is optional and defaults to the localised term PhD thesis.", new Object[0]);
                }
                case Proceedings: {
                    return Localization.lang("A single-volume conference proceedings. This type is very similar to \"Collection\".", new Object[0]);
                }
                case TechReport: {
                    return Localization.lang("Similar to \"Report\" except that the type field is optional and defaults to the localised term technical report.", new Object[0]);
                }
                case Unpublished: {
                    return Localization.lang("A work with an author and a title which has not been formally published, such as a manuscript or the script of a talk.", new Object[0]);
                }
                case BookInBook: {
                    return Localization.lang("This type is similar to \"InBook\" but intended for works originally published as a stand-alone book.", new Object[0]);
                }
                case InReference: {
                    return Localization.lang("An article in a work of reference. This is a more specific variant of the generic \"InCollection\" entry type.", new Object[0]);
                }
                case MvBook: {
                    return Localization.lang("A multi-volume \"Book\".", new Object[0]);
                }
                case MvCollection: {
                    return Localization.lang("A multi-volume \"Collection\".", new Object[0]);
                }
                case MvProceedings: {
                    return Localization.lang("A multi-volume \"Proceedings\" entry.", new Object[0]);
                }
                case MvReference: {
                    return Localization.lang("A multi-volume \"Reference\" entry. The standard styles will treat this entry type as an alias for \"MvCollection\".", new Object[0]);
                }
                case Online: {
                    return Localization.lang("This entry type is intended for sources such as web sites which are intrinsically online resources.", new Object[0]);
                }
                case Reference: {
                    return Localization.lang("A single-volume work of reference such as an encyclopedia or a dictionary.", new Object[0]);
                }
                case Report: {
                    return Localization.lang("A technical report, research report, or white paper published by a university or some other institution.", new Object[0]);
                }
                case Set: {
                    return Localization.lang("An entry set is a group of entries which are cited as a single reference and listed as a single item in the bibliography.", new Object[0]);
                }
                case SuppBook: {
                    return Localization.lang("Supplemental material in a \"Book\". This type is provided for elements such as prefaces, introductions, forewords, afterwords, etc. which often have a generic title only.", new Object[0]);
                }
                case SuppCollection: {
                    return Localization.lang("Supplemental material in a \"Collection\".", new Object[0]);
                }
                case SuppPeriodical: {
                    return Localization.lang("Supplemental material in a \"Periodical\". This type may be useful when referring to items such as regular columns, obituaries, letters to the editor, etc. which only have a generic title.", new Object[0]);
                }
                case Thesis: {
                    return Localization.lang("A thesis written for an educational institution to satisfy the requirements for a degree.", new Object[0]);
                }
                case WWW: {
                    return Localization.lang("An alias for \"Online\", provided for jurabib compatibility.", new Object[0]);
                }
                case Software: {
                    return Localization.lang("Computer software. The standard styles will treat this entry type as an alias for \"Misc\".", new Object[0]);
                }
                case Dataset: {
                    return Localization.lang("A data set or a similar collection of (mostly) raw data.", new Object[0]);
                }
            }
            return "";
        }
        return "";
    }
}

