/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import com.airhacks.afterburner.injection.Injector;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.exporter.SaveDatabaseAction;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;

public class SaveAction
extends SimpleCommand {
    private final SaveMethod saveMethod;
    private final Supplier<LibraryTab> tabSupplier;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;

    public SaveAction(SaveMethod saveMethod, Supplier<LibraryTab> tabSupplier, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager) {
        this.saveMethod = saveMethod;
        this.tabSupplier = tabSupplier;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        if (saveMethod == SaveMethod.SAVE_SELECTED) {
            this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
        } else {
            this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
        }
    }

    public void execute() {
        SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction(this.tabSupplier.get(), this.dialogService, this.preferencesService, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class));
        switch (this.saveMethod.ordinal()) {
            case 0: {
                saveDatabaseAction.save();
                break;
            }
            case 1: {
                saveDatabaseAction.saveAs();
                break;
            }
            case 2: {
                saveDatabaseAction.saveSelectedAsPlain();
            }
        }
    }

    public static enum SaveMethod {
        SAVE,
        SAVE_AS,
        SAVE_SELECTED;

    }
}

