/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitIgnoreFileFilter
implements DirectoryStream.Filter<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitIgnoreFileFilter.class);
    private Set<PathMatcher> gitIgnorePatterns;

    public GitIgnoreFileFilter(Path path) {
        Path currentPath;
        for (currentPath = path; currentPath != null && !Files.exists(currentPath.resolve(".gitignore"), new LinkOption[0]); currentPath = currentPath.getParent()) {
        }
        if (currentPath == null) {
            this.gitIgnorePatterns = Set.of(".git", ".DS_Store", "desktop.ini", "Thumbs.db").stream().map(line -> "glob:" + line).map(matcherString -> FileSystems.getDefault().getPathMatcher((String)matcherString)).collect(Collectors.toSet());
        } else {
            Path gitIgnore = currentPath.resolve(".gitignore");
            try {
                Set plainGitIgnorePatternsFromGitIgnoreFile = Files.readAllLines(gitIgnore).stream().map(String::trim).filter(Predicate.not(String::isEmpty)).filter(line -> !line.startsWith("#")).map(line -> "glob:" + line).map(matcherString -> FileSystems.getDefault().getPathMatcher((String)matcherString)).collect(Collectors.toSet());
                this.gitIgnorePatterns = new HashSet(plainGitIgnorePatternsFromGitIgnoreFile);
                this.gitIgnorePatterns.add(FileSystems.getDefault().getPathMatcher("glob:.gitignore"));
            }
            catch (IOException e) {
                LOGGER.info("Could not read .gitignore from {}", (Object)gitIgnore, (Object)e);
                this.gitIgnorePatterns = Set.of();
            }
        }
    }

    @Override
    public boolean accept(Path path) throws IOException {
        return this.gitIgnorePatterns.stream().noneMatch(filter -> filter.matches(path.getFileName()) || filter.matches(path));
    }
}

