/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jabref.logic.util.io.DatabaseFileLookup;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.FilePreferences;

public class UnlinkedPDFFileFilter
implements DirectoryStream.Filter<Path> {
    private final DatabaseFileLookup lookup;
    private final DirectoryStream.Filter<Path> fileFilter;

    public UnlinkedPDFFileFilter(DirectoryStream.Filter<Path> fileFilter, BibDatabaseContext databaseContext, FilePreferences filePreferences) {
        this.fileFilter = fileFilter;
        this.lookup = new DatabaseFileLookup(databaseContext, filePreferences);
    }

    @Override
    public boolean accept(Path pathname) throws IOException {
        if (Files.isDirectory(pathname, new LinkOption[0])) {
            return true;
        }
        return this.fileFilter.accept(pathname) && !this.lookup.lookupDatabase(pathname) && !this.lookup.getPathOfDatabase().equals(pathname);
    }
}

