/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiletype;

import java.util.Objects;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;

public class CustomExternalFileType
implements ExternalFileType {
    private String name;
    private String extension;
    private String openWith;
    private String iconName;
    private String mimeType;
    private JabRefIcon icon;

    public CustomExternalFileType(String name, String extension, String mimeType, String openWith, String iconName, JabRefIcon icon) {
        this.name = name;
        this.extension = extension;
        this.mimeType = mimeType;
        this.openWith = openWith;
        this.setIconName(iconName);
        this.setIcon(icon);
    }

    public CustomExternalFileType(ExternalFileType type) {
        this(type.getName(), type.getExtension(), type.getMimeType(), type.getOpenWithApplication(), "", type.getIcon());
    }

    public static ExternalFileType buildFromArgs(String[] val) {
        String iconName;
        String openWith;
        String mimeType;
        if (val == null || val.length < 4 || val.length > 5) {
            throw new IllegalArgumentException("Cannot construct ExternalFileType without four elements in String[] argument.");
        }
        String name = val[0];
        String extension = val[1];
        if (val.length == 4) {
            mimeType = "";
            openWith = val[2];
            iconName = val[3];
        } else {
            mimeType = val[2];
            openWith = val[3];
            iconName = val[4];
        }
        JabRefIcon icon = IconTheme.JabRefIcons.FILE;
        for (ExternalFileType fileType : ExternalFileTypes.getDefaultExternalFileTypes()) {
            if (!fileType.getName().equals(name)) continue;
            icon = fileType.getIcon();
            break;
        }
        return new CustomExternalFileType(name, extension, mimeType, openWith, iconName, icon);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getExtension() {
        if (this.extension == null) {
            return "";
        }
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public String getMimeType() {
        if (this.mimeType == null) {
            return "";
        }
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getOpenWithApplication() {
        if (this.openWith == null) {
            return "";
        }
        return this.openWith;
    }

    public void setOpenWith(String openWith) {
        this.openWith = openWith;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String name) {
        this.iconName = name;
    }

    @Override
    public JabRefIcon getIcon() {
        return this.icon;
    }

    public void setIcon(JabRefIcon icon) {
        Objects.requireNonNull(icon);
        this.icon = icon;
    }

    public String toString() {
        return this.getName();
    }

    public ExternalFileType copy() {
        return new CustomExternalFileType(this.name, this.extension, this.mimeType, this.openWith, this.iconName, this.icon);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.extension, this.mimeType, this.openWith, this.iconName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CustomExternalFileType) {
            CustomExternalFileType other = (CustomExternalFileType)object;
            return Objects.equals(this.name, other.name) && Objects.equals(this.extension, other.extension) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.openWith, other.openWith) && Objects.equals(this.iconName, other.iconName);
        }
        return false;
    }
}

