/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.time.format.DateTimeFormatter;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.DateEditorViewModel;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.component.TemporalAccessorPicker;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class DateEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private DateEditorViewModel viewModel;
    @FXML
    private TemporalAccessorPicker datePicker;
    @Inject
    private UndoManager undoManager;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private KeyBindingRepository keyBindingRepository;

    public DateEditor(Field field, DateTimeFormatter dateFormatter, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, UndoAction undoAction, RedoAction redoAction) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new DateEditorViewModel(field, suggestionProvider, dateFormatter, fieldCheckers, this.undoManager);
        this.datePicker.setStringConverter(this.viewModel.getDateToStringConverter());
        this.establishBinding((TextInputControl)this.datePicker.getEditor(), this.viewModel.textProperty(), this.keyBindingRepository, undoAction, redoAction);
        new EditorValidator(this.preferencesService).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), (TextInputControl)this.datePicker.getEditor());
    }

    public DateEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }
}

