/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import javafx.scene.control.TextInputControl;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.SimpleEditor;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class MarkdownEditor
extends SimpleEditor {
    private final FlexmarkHtmlConverter flexmarkHtmlConverter = FlexmarkHtmlConverter.builder().build();

    public MarkdownEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, PreferencesService preferences, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction) {
        super(field, suggestionProvider, fieldCheckers, preferences, true, undoManager, undoAction, redoAction);
    }

    @Override
    protected TextInputControl createTextInputControl() {
        return new EditorTextArea(){

            @Override
            public void paste() {
                if (ClipBoardManager.hasHtml()) {
                    String htmlText = ClipBoardManager.getHtmlContents();
                    String mdText = MarkdownEditor.this.flexmarkHtmlConverter.convert(htmlText);
                    super.replaceSelection(mdText);
                } else {
                    super.paste();
                }
            }
        };
    }
}

