/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.OwnerEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.EditorMenus;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class OwnerEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private OwnerEditorViewModel viewModel;
    @FXML
    private EditorTextArea textArea;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private UndoManager undoManager;

    public OwnerEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, UndoAction undoAction, RedoAction redoAction) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new OwnerEditorViewModel(field, suggestionProvider, this.preferencesService, fieldCheckers, this.undoManager);
        this.establishBinding((TextInputControl)this.textArea, this.viewModel.textProperty(), this.keyBindingRepository, undoAction, redoAction);
        this.textArea.initContextMenu(EditorMenus.getNameMenu((TextInputControl)this.textArea), this.keyBindingRepository);
        new EditorValidator(this.preferencesService).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), (TextInputControl)this.textArea);
    }

    public OwnerEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void setOwner() {
        this.viewModel.setOwner();
    }
}

