/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.injection.Injector;
import javafx.scene.Parent;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.autocompleter.AutoCompletionTextInputBinding;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.ContextMenuAddable;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorTextField;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.PersonsEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.EditorMenus;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.uithreadaware.UiThreadStringProperty;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class PersonsEditor
extends HBox
implements FieldEditorFX {
    private final PersonsEditorViewModel viewModel;
    private final TextInputControl textInput;
    private final UiThreadStringProperty decoratedStringProperty;

    public PersonsEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, boolean isMultiLine, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction) {
        PreferencesService preferencesService = (PreferencesService)Injector.instantiateModelOrService(PreferencesService.class);
        KeyBindingRepository keyBindingRepository = preferencesService.getKeyBindingRepository();
        this.viewModel = new PersonsEditorViewModel(field, suggestionProvider, preferencesService.getAutoCompletePreferences(), fieldCheckers, undoManager);
        this.textInput = isMultiLine ? new EditorTextArea() : new EditorTextField();
        this.decoratedStringProperty = new UiThreadStringProperty(this.viewModel.textProperty());
        this.establishBinding(this.textInput, this.decoratedStringProperty, keyBindingRepository, undoAction, redoAction);
        ((ContextMenuAddable)this.textInput).initContextMenu(EditorMenus.getNameMenu(this.textInput), keyBindingRepository);
        this.getChildren().add((Object)this.textInput);
        AutoCompletionTextInputBinding.autoComplete(this.textInput, this.viewModel::complete, this.viewModel.getAutoCompletionConverter(), this.viewModel.getAutoCompletionStrategy());
        new EditorValidator(preferencesService).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), this.textInput);
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    public void requestFocus() {
        this.textInput.requestFocus();
    }
}

