/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.util.List;
import java.util.function.Supplier;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.UrlEditorViewModel;
import org.jabref.gui.fieldeditors.contextmenu.EditorMenus;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.logic.formatter.bibtexfields.CleanupUrlFormatter;
import org.jabref.logic.formatter.bibtexfields.TrimWhitespaceFormatter;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class UrlEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private final UrlEditorViewModel viewModel;
    @FXML
    private EditorTextArea textArea;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private KeyBindingRepository keyBindingRepository;
    @Inject
    private UndoManager undoManager;

    public UrlEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, UndoAction undoAction, RedoAction redoAction) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new UrlEditorViewModel(field, suggestionProvider, this.dialogService, this.preferencesService, fieldCheckers, this.undoManager);
        this.establishBinding((TextInputControl)this.textArea, this.viewModel.textProperty(), this.keyBindingRepository, undoAction, redoAction);
        Supplier<List<MenuItem>> contextMenuSupplier = EditorMenus.getCleanupUrlMenu(this.textArea);
        this.textArea.initContextMenu(contextMenuSupplier, this.preferencesService.getKeyBindingRepository());
        this.textArea.setPasteActionHandler(() -> this.textArea.setText(new CleanupUrlFormatter().format(new TrimWhitespaceFormatter().format(this.textArea.getText()))));
        new EditorValidator(this.preferencesService).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), (TextInputControl)this.textArea);
    }

    public UrlEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void openExternalLink(ActionEvent event) {
        this.viewModel.openExternalLink();
    }
}

