/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.contextmenu;

import com.airhacks.afterburner.injection.Injector;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.edit.CopyDoiUrlAction;
import org.jabref.gui.fieldeditors.contextmenu.DefaultMenu;
import org.jabref.logic.formatter.bibtexfields.CleanupUrlFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;

public class EditorMenus {
    public static Supplier<List<MenuItem>> getNameMenu(TextInputControl textInput) {
        return () -> {
            MenuItem normalizeNames = new MenuItem(Localization.lang("Normalize to BibTeX name format", new Object[0]));
            EasyBind.subscribe((ObservableValue)textInput.textProperty(), value -> normalizeNames.setDisable(StringUtil.isNullOrEmpty(value)));
            normalizeNames.setOnAction(event -> textInput.setText(new NormalizeNamesFormatter().format(textInput.getText())));
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>(6);
            menuItems.add(normalizeNames);
            menuItems.addAll((Collection<MenuItem>)new DefaultMenu(textInput).get());
            return menuItems;
        };
    }

    public static Supplier<List<MenuItem>> getDOIMenu(TextArea textArea, DialogService dialogService) {
        return () -> {
            ActionFactory factory = new ActionFactory();
            ClipBoardManager clipBoardManager = (ClipBoardManager)Injector.instantiateModelOrService(ClipBoardManager.class);
            MenuItem copyDoiMenuItem = factory.createMenuItem(StandardActions.COPY_DOI, (Command)new CopyDoiUrlAction(textArea, StandardActions.COPY_DOI, dialogService, clipBoardManager));
            MenuItem copyDoiUrlMenuItem = factory.createMenuItem(StandardActions.COPY_DOI_URL, (Command)new CopyDoiUrlAction(textArea, StandardActions.COPY_DOI_URL, dialogService, clipBoardManager));
            ArrayList<Object> menuItems = new ArrayList<Object>();
            menuItems.add(copyDoiMenuItem);
            menuItems.add(copyDoiUrlMenuItem);
            menuItems.add(new SeparatorMenuItem());
            menuItems.addAll((Collection<Object>)new DefaultMenu((TextInputControl)textArea).get());
            return menuItems;
        };
    }

    public static Supplier<List<MenuItem>> getCleanupUrlMenu(TextArea textArea) {
        return () -> {
            MenuItem cleanupURL = new MenuItem(Localization.lang("Cleanup URL link", new Object[0]));
            cleanupURL.setDisable(textArea.textProperty().isEmpty().get());
            cleanupURL.setOnAction(event -> textArea.setText(new CleanupUrlFormatter().format(textArea.getText())));
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            menuItems.add(cleanupURL);
            return menuItems;
        };
    }
}

