/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.identifier;

import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.identifier.BaseIdentifierEditorViewModel;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.identifier.ISBN;
import org.jabref.preferences.PreferencesService;

public class ISBNIdentifierEditorViewModel
extends BaseIdentifierEditorViewModel<ISBN> {
    private final UndoManager undoManager;
    private final StateManager stateManager;

    public ISBNIdentifierEditorViewModel(SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, DialogService dialogService, TaskExecutor taskExecutor, PreferencesService preferences, UndoManager undoManager, StateManager stateManager) {
        super(StandardField.ISBN, suggestionProvider, fieldCheckers, dialogService, taskExecutor, preferences, undoManager);
        this.undoManager = undoManager;
        this.stateManager = stateManager;
        this.configure(true, false);
    }

    @Override
    public void fetchBibliographyInformation(BibEntry bibEntry) {
        this.stateManager.getActiveDatabase().ifPresentOrElse(databaseContext -> new FetchAndMergeEntry((BibDatabaseContext)databaseContext, this.taskExecutor, this.preferences, this.dialogService, this.undoManager).fetchAndMerge(this.entry, this.field), () -> this.dialogService.notify(Localization.lang("No library selected", new Object[0])));
    }
}

