/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.optioneditors.mapbased;

import com.google.common.collect.BiMap;
import java.util.Collection;
import javafx.util.StringConverter;
import javax.swing.undo.UndoManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.optioneditors.OptionEditorViewModel;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.field.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapBasedEditorViewModel<T>
extends OptionEditorViewModel<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBasedEditorViewModel.class);

    public MapBasedEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, UndoManager undoManager) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
    }

    protected abstract BiMap<String, T> getItemMap();

    @Override
    public StringConverter<T> getStringConverter() {
        return new StringConverter<T>(){

            public String toString(T object) {
                if (object == null) {
                    return null;
                }
                return (String)MapBasedEditorViewModel.this.getItemMap().inverse().getOrDefault(object, (Object)object.toString());
            }

            public T fromString(String string) {
                if (string == null) {
                    return null;
                }
                return MapBasedEditorViewModel.this.getItemMap().getOrDefault((Object)string, MapBasedEditorViewModel.this.getValueFromString(string));
            }
        };
    }

    protected T getValueFromString(String string) {
        try {
            return (T)string;
        }
        catch (ClassCastException ex) {
            LOGGER.error("Could not cast string to type %1$s. Try overriding the method in a subclass and provide a conversion from string to the concrete type %1$s".formatted(string.getClass()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public Collection<T> getItems() {
        return this.getItemMap().values();
    }
}

