/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import com.tobiasdiez.easybind.EasyBind;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.skin.TabPaneSkin;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.GroupTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameDndHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameDndHandler.class);
    private final TabPane tabPane;
    private final Supplier<Scene> scene;
    private final Supplier<OpenDatabaseAction> openDatabaseAction;
    private final StateManager stateManager;

    public FrameDndHandler(TabPane tabPane, Supplier<Scene> scene, Supplier<OpenDatabaseAction> openDatabaseAction, StateManager stateManager) {
        this.tabPane = tabPane;
        this.scene = scene;
        this.openDatabaseAction = openDatabaseAction;
        this.stateManager = stateManager;
    }

    void initDragAndDrop() {
        this.tabPane.setTabDragPolicy(TabPane.TabDragPolicy.REORDER);
        Tab dndIndicator = new Tab(Localization.lang("Open files...", new Object[0]), null);
        dndIndicator.getStyleClass().add((Object)"drop");
        EasyBind.subscribe((ObservableValue)this.tabPane.skinProperty(), skin -> {
            if (!(skin instanceof TabPaneSkin)) {
                return;
            }
            this.scene.get().setOnDragOver(event -> this.onSceneDragOver((DragEvent)event, dndIndicator));
            this.scene.get().setOnDragEntered(event -> {
                for (Node destinationTabNode : this.tabPane.lookupAll(".tab")) {
                    destinationTabNode.setOnDragOver(tabDragEvent -> this.onTabDragOver((DragEvent)event, (DragEvent)tabDragEvent, dndIndicator));
                    destinationTabNode.setOnDragExited(tabDragEvent -> this.tabPane.getTabs().remove((Object)dndIndicator));
                    destinationTabNode.setOnDragDropped(tabDragEvent -> this.onTabDragDropped(destinationTabNode, (DragEvent)tabDragEvent, dndIndicator));
                }
                event.consume();
            });
            this.scene.get().setOnDragExited(event -> this.tabPane.getTabs().remove((Object)dndIndicator));
            this.scene.get().setOnDragDropped(event -> this.onSceneDragDropped((DragEvent)event, dndIndicator));
        });
    }

    private void onTabDragDropped(Node destinationTabNode, DragEvent tabDragEvent, Tab dndIndicator) {
        Dragboard dragboard = tabDragEvent.getDragboard();
        if (this.hasBibFiles(dragboard)) {
            this.tabPane.getTabs().remove((Object)dndIndicator);
            List<Path> bibFiles = this.getBibFiles(dragboard);
            OpenDatabaseAction openDatabaseAction = this.openDatabaseAction.get();
            openDatabaseAction.openFiles(bibFiles);
            tabDragEvent.setDropCompleted(true);
            tabDragEvent.consume();
        } else {
            if (this.stateManager.getActiveDatabase().isEmpty()) {
                LOGGER.warn("Active library is empty when dropping entries");
                return;
            }
            LibraryTab destinationLibraryTab = null;
            for (Tab libraryTab : this.tabPane.getTabs()) {
                if (!libraryTab.getId().equals(destinationTabNode.getId()) || ((Tab)this.tabPane.getSelectionModel().getSelectedItem()).equals(libraryTab)) continue;
                destinationLibraryTab = (LibraryTab)libraryTab;
                break;
            }
            if (destinationLibraryTab == null) {
                LOGGER.warn("Failed to find library tab to drop into");
                return;
            }
            if (this.hasEntries(dragboard)) {
                List<BibEntry> entryCopies = this.stateManager.getLocalDragboard().getBibEntries().stream().map(entry -> (BibEntry)entry.clone()).toList();
                destinationLibraryTab.dropEntry(entryCopies);
            } else if (this.hasGroups(dragboard)) {
                this.dropGroups(dragboard, destinationLibraryTab);
            }
            tabDragEvent.consume();
        }
    }

    private void dropGroups(Dragboard dragboard, LibraryTab destinationLibraryTab) {
        List<String> groupPathToSources = this.getGroups(dragboard);
        this.copyRootNode(destinationLibraryTab);
        GroupTreeNode destinationLibraryGroupRoot = destinationLibraryTab.getBibDatabaseContext().getMetaData().getGroups().get();
        GroupTreeNode groupsTreeNode = this.stateManager.getActiveDatabase().get().getMetaData().getGroups().get();
        for (String pathToSource : groupPathToSources) {
            GroupTreeNode groupTreeNodeToCopy = groupsTreeNode.getChildByPath(pathToSource).get();
            this.copyGroupTreeNode(destinationLibraryTab, destinationLibraryGroupRoot, groupTreeNodeToCopy);
        }
    }

    private boolean hasEntries(Dragboard dragboard) {
        return dragboard.hasContent(DragAndDropDataFormats.ENTRIES);
    }

    private void onTabDragOver(DragEvent event, DragEvent tabDragEvent, Tab dndIndicator) {
        if (this.hasBibFiles(tabDragEvent.getDragboard()) || this.hasGroups(tabDragEvent.getDragboard())) {
            tabDragEvent.acceptTransferModes(TransferMode.ANY);
            if (!this.tabPane.getTabs().contains((Object)dndIndicator)) {
                this.tabPane.getTabs().add((Object)dndIndicator);
            }
            event.consume();
        } else {
            this.tabPane.getTabs().remove((Object)dndIndicator);
        }
        if (tabDragEvent.getDragboard().hasContent(DragAndDropDataFormats.ENTRIES)) {
            tabDragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            tabDragEvent.consume();
        }
    }

    private void onSceneDragOver(DragEvent event, Tab dndIndicator) {
        if (this.hasBibFiles(event.getDragboard())) {
            event.acceptTransferModes(TransferMode.ANY);
            if (!this.tabPane.getTabs().contains((Object)dndIndicator)) {
                this.tabPane.getTabs().add((Object)dndIndicator);
            }
            event.consume();
        } else {
            this.tabPane.getTabs().remove((Object)dndIndicator);
        }
        if (event.getDragboard().hasContent(DragAndDropDataFormats.ENTRIES)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            event.consume();
        }
    }

    private void onSceneDragDropped(DragEvent event, Tab dndIndicator) {
        this.tabPane.getTabs().remove((Object)dndIndicator);
        List<Path> bibFiles = this.getBibFiles(event.getDragboard());
        OpenDatabaseAction openDatabaseAction = this.openDatabaseAction.get();
        openDatabaseAction.openFiles(bibFiles);
        event.setDropCompleted(true);
        event.consume();
    }

    private void copyRootNode(LibraryTab destinationLibraryTab) {
        if (destinationLibraryTab.getBibDatabaseContext().getMetaData().getGroups().isPresent() && this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        GroupTreeNode currentLibraryGroupRoot = this.stateManager.getActiveDatabase().get().getMetaData().getGroups().get().copyNode();
        destinationLibraryTab.getBibDatabaseContext().getMetaData().setGroups(currentLibraryGroupRoot);
    }

    private void copyGroupTreeNode(LibraryTab destinationLibraryTab, GroupTreeNode parent, GroupTreeNode groupTreeNodeToCopy) {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        List<BibEntry> allEntries = this.stateManager.getActiveDatabase().get().getEntries();
        GroupTreeNode copiedNode = parent.addSubgroup(groupTreeNodeToCopy.copyNode().getGroup());
        destinationLibraryTab.dropEntry(groupTreeNodeToCopy.getEntriesInGroup(allEntries));
        ObservableList children = groupTreeNodeToCopy.getChildren();
        if (!children.isEmpty()) {
            for (GroupTreeNode child : children) {
                this.copyGroupTreeNode(destinationLibraryTab, copiedNode, child);
            }
        }
    }

    private boolean hasBibFiles(Dragboard dragboard) {
        return !this.getBibFiles(dragboard).isEmpty();
    }

    private List<Path> getBibFiles(Dragboard dragboard) {
        if (!dragboard.hasFiles()) {
            return Collections.emptyList();
        }
        return dragboard.getFiles().stream().map(File::toPath).filter(FileUtil::isBibFile).collect(Collectors.toList());
    }

    private boolean hasGroups(Dragboard dragboard) {
        return !this.getGroups(dragboard).isEmpty();
    }

    private List<String> getGroups(Dragboard dragboard) {
        if (!dragboard.hasContent(DragAndDropDataFormats.GROUP)) {
            return Collections.emptyList();
        }
        return (List)dragboard.getContent(DragAndDropDataFormats.GROUP);
    }
}

