/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.function.Supplier;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.auximport.NewSubLibraryAction;
import org.jabref.gui.bibtexextractor.ExtractBibtexAction;
import org.jabref.gui.citationkeypattern.GenerateCitationKeyAction;
import org.jabref.gui.cleanup.CleanupAction;
import org.jabref.gui.copyfiles.CopyFilesAction;
import org.jabref.gui.documentviewer.ShowDocumentViewerAction;
import org.jabref.gui.duplicationFinder.DuplicateSearch;
import org.jabref.gui.edit.CopyMoreAction;
import org.jabref.gui.edit.EditAction;
import org.jabref.gui.edit.ManageKeywordsAction;
import org.jabref.gui.edit.OpenBrowserAction;
import org.jabref.gui.edit.ReplaceStringAction;
import org.jabref.gui.edit.automaticfiededitor.AutomaticFieldEditorAction;
import org.jabref.gui.entryeditor.OpenEntryEditorAction;
import org.jabref.gui.entryeditor.PreviewSwitchAction;
import org.jabref.gui.exporter.ExportCommand;
import org.jabref.gui.exporter.ExportToClipboardAction;
import org.jabref.gui.exporter.SaveAction;
import org.jabref.gui.exporter.SaveAllAction;
import org.jabref.gui.exporter.WriteMetadataToLinkedPdfsAction;
import org.jabref.gui.externalfiles.AutoLinkFilesAction;
import org.jabref.gui.externalfiles.DownloadFullTextAction;
import org.jabref.gui.externalfiles.FindUnlinkedFilesAction;
import org.jabref.gui.frame.FileHistoryMenu;
import org.jabref.gui.frame.JabRefFrame;
import org.jabref.gui.frame.OpenConsoleAction;
import org.jabref.gui.frame.SendAsKindleEmailAction;
import org.jabref.gui.frame.SendAsStandardEmailAction;
import org.jabref.gui.help.AboutAction;
import org.jabref.gui.help.ErrorConsoleAction;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.help.SearchForUpdateAction;
import org.jabref.gui.importer.ImportCommand;
import org.jabref.gui.importer.NewDatabaseAction;
import org.jabref.gui.importer.NewEntryAction;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.gui.importer.fetcher.LookupIdentifierAction;
import org.jabref.gui.integrity.IntegrityCheckAction;
import org.jabref.gui.journals.AbbreviateAction;
import org.jabref.gui.libraryproperties.LibraryPropertiesAction;
import org.jabref.gui.linkedfile.RedownloadMissingFilesAction;
import org.jabref.gui.mergeentries.MergeEntriesAction;
import org.jabref.gui.preferences.ShowPreferencesAction;
import org.jabref.gui.preview.CopyCitationAction;
import org.jabref.gui.push.PushToApplicationCommand;
import org.jabref.gui.search.RebuildFulltextSearchIndexAction;
import org.jabref.gui.shared.ConnectToSharedDatabaseCommand;
import org.jabref.gui.shared.PullChangesFromSharedAction;
import org.jabref.gui.sidepane.SidePane;
import org.jabref.gui.sidepane.SidePaneType;
import org.jabref.gui.slr.EditExistingStudyAction;
import org.jabref.gui.slr.ExistingStudySearchAction;
import org.jabref.gui.slr.StartNewStudyAction;
import org.jabref.gui.specialfields.SpecialFieldMenuItemFactory;
import org.jabref.gui.texparser.ParseLatexAction;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.citationstyle.CitationStyleOutputFormat;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.IdFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class MainMenu
extends MenuBar {
    private final JabRefFrame frame;
    private final FileHistoryMenu fileHistoryMenu;
    private final SidePane sidePane;
    private final PushToApplicationCommand pushToApplicationCommand;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final TaskExecutor taskExecutor;
    private final DialogService dialogService;
    private final JournalAbbreviationRepository abbreviationRepository;
    private final BibEntryTypesManager entryTypesManager;
    private final UndoManager undoManager;
    private final ClipBoardManager clipBoardManager;
    private final Supplier<OpenDatabaseAction> openDatabaseActionSupplier;

    public MainMenu(JabRefFrame frame, FileHistoryMenu fileHistoryMenu, SidePane sidePane, PushToApplicationCommand pushToApplicationCommand, PreferencesService preferencesService, StateManager stateManager, FileUpdateMonitor fileUpdateMonitor, TaskExecutor taskExecutor, DialogService dialogService, JournalAbbreviationRepository abbreviationRepository, BibEntryTypesManager entryTypesManager, UndoManager undoManager, ClipBoardManager clipBoardManager, Supplier<OpenDatabaseAction> openDatabaseActionSupplier) {
        this.frame = frame;
        this.fileHistoryMenu = fileHistoryMenu;
        this.sidePane = sidePane;
        this.pushToApplicationCommand = pushToApplicationCommand;
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
        this.abbreviationRepository = abbreviationRepository;
        this.entryTypesManager = entryTypesManager;
        this.undoManager = undoManager;
        this.clipBoardManager = clipBoardManager;
        this.openDatabaseActionSupplier = openDatabaseActionSupplier;
        this.createMenu();
    }

    private void createMenu() {
        ActionFactory factory = new ActionFactory();
        Menu file = new Menu(Localization.lang("File", new Object[0]));
        Menu edit = new Menu(Localization.lang("Edit", new Object[0]));
        Menu library = new Menu(Localization.lang("Library", new Object[0]));
        Menu quality = new Menu(Localization.lang("Quality", new Object[0]));
        Menu lookup = new Menu(Localization.lang("Lookup", new Object[0]));
        Menu view = new Menu(Localization.lang("View", new Object[0]));
        Menu tools = new Menu(Localization.lang("Tools", new Object[0]));
        Menu help = new Menu(Localization.lang("Help", new Object[0]));
        Object[] objectArray = new MenuItem[16];
        objectArray[0] = factory.createMenuItem(StandardActions.NEW_LIBRARY, (Command)new NewDatabaseAction(this.frame, this.preferencesService));
        objectArray[1] = factory.createMenuItem(StandardActions.OPEN_LIBRARY, (Command)this.openDatabaseActionSupplier.get());
        objectArray[2] = this.fileHistoryMenu;
        objectArray[3] = factory.createMenuItem(StandardActions.SAVE_LIBRARY, (Command)new SaveAction(SaveAction.SaveMethod.SAVE, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.stateManager));
        objectArray[4] = factory.createMenuItem(StandardActions.SAVE_LIBRARY_AS, (Command)new SaveAction(SaveAction.SaveMethod.SAVE_AS, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.stateManager));
        objectArray[5] = factory.createMenuItem(StandardActions.SAVE_ALL, (Command)new SaveAllAction(this.frame::getLibraryTabs, this.preferencesService, this.dialogService));
        objectArray[6] = factory.createMenuItem(StandardActions.CLOSE_LIBRARY, (Command)new JabRefFrame.CloseDatabaseAction(this.frame, this.stateManager));
        objectArray[7] = new SeparatorMenuItem();
        objectArray[8] = factory.createSubMenu(StandardActions.IMPORT, factory.createMenuItem(StandardActions.IMPORT_INTO_CURRENT_LIBRARY, (Command)new ImportCommand(this.frame, ImportCommand.ImportMethod.TO_EXISTING, this.preferencesService, this.stateManager, this.fileUpdateMonitor, this.taskExecutor, this.dialogService)), factory.createMenuItem(StandardActions.IMPORT_INTO_NEW_LIBRARY, (Command)new ImportCommand(this.frame, ImportCommand.ImportMethod.AS_NEW, this.preferencesService, this.stateManager, this.fileUpdateMonitor, this.taskExecutor, this.dialogService)));
        MenuItem[] menuItemArray = new MenuItem[3];
        menuItemArray[0] = factory.createMenuItem(StandardActions.EXPORT_ALL, (Command)new ExportCommand(ExportCommand.ExportMethod.EXPORT_ALL, this.frame::getCurrentLibraryTab, this.stateManager, this.dialogService, this.preferencesService, this.entryTypesManager, this.abbreviationRepository, this.taskExecutor));
        menuItemArray[1] = factory.createMenuItem(StandardActions.EXPORT_SELECTED, (Command)new ExportCommand(ExportCommand.ExportMethod.EXPORT_SELECTED, this.frame::getCurrentLibraryTab, this.stateManager, this.dialogService, this.preferencesService, this.entryTypesManager, this.abbreviationRepository, this.taskExecutor));
        menuItemArray[2] = factory.createMenuItem(StandardActions.SAVE_SELECTED_AS_PLAIN_BIBTEX, (Command)new SaveAction(SaveAction.SaveMethod.SAVE_SELECTED, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.stateManager));
        objectArray[9] = factory.createSubMenu(StandardActions.EXPORT, menuItemArray);
        objectArray[10] = new SeparatorMenuItem();
        objectArray[11] = factory.createSubMenu(StandardActions.REMOTE_DB, factory.createMenuItem(StandardActions.CONNECT_TO_SHARED_DB, (Command)new ConnectToSharedDatabaseCommand(this.frame, this.dialogService)), factory.createMenuItem(StandardActions.PULL_CHANGES_FROM_SHARED_DB, (Command)new PullChangesFromSharedAction(this.stateManager)));
        objectArray[12] = new SeparatorMenuItem();
        objectArray[13] = factory.createMenuItem(StandardActions.SHOW_PREFS, (Command)new ShowPreferencesAction(this.frame, this.dialogService));
        objectArray[14] = new SeparatorMenuItem();
        objectArray[15] = factory.createMenuItem(StandardActions.QUIT, (Command)new JabRefFrame.CloseAction(this.frame));
        file.getItems().addAll(objectArray);
        Object[] objectArray2 = new MenuItem[13];
        objectArray2[0] = factory.createMenuItem(StandardActions.UNDO, (Command)new UndoAction(this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager));
        objectArray2[1] = factory.createMenuItem(StandardActions.REDO, (Command)new RedoAction(this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager));
        objectArray2[2] = new SeparatorMenuItem();
        objectArray2[3] = factory.createMenuItem(StandardActions.CUT, (Command)new EditAction(StandardActions.CUT, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        objectArray2[4] = factory.createMenuItem(StandardActions.COPY, (Command)new EditAction(StandardActions.COPY, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        objectArray2[5] = factory.createSubMenu(StandardActions.COPY_MORE, factory.createMenuItem(StandardActions.COPY_TITLE, (Command)new CopyMoreAction(StandardActions.COPY_TITLE, this.dialogService, this.stateManager, this.clipBoardManager, this.preferencesService, this.abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_KEY, (Command)new CopyMoreAction(StandardActions.COPY_KEY, this.dialogService, this.stateManager, this.clipBoardManager, this.preferencesService, this.abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_CITE_KEY, (Command)new CopyMoreAction(StandardActions.COPY_CITE_KEY, this.dialogService, this.stateManager, this.clipBoardManager, this.preferencesService, this.abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_KEY_AND_TITLE, (Command)new CopyMoreAction(StandardActions.COPY_KEY_AND_TITLE, this.dialogService, this.stateManager, this.clipBoardManager, this.preferencesService, this.abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_KEY_AND_LINK, (Command)new CopyMoreAction(StandardActions.COPY_KEY_AND_LINK, this.dialogService, this.stateManager, this.clipBoardManager, this.preferencesService, this.abbreviationRepository)), factory.createMenuItem(StandardActions.COPY_CITATION_PREVIEW, (Command)new CopyCitationAction(CitationStyleOutputFormat.HTML, this.dialogService, this.stateManager, this.clipBoardManager, this.taskExecutor, this.preferencesService, this.abbreviationRepository)), factory.createMenuItem(StandardActions.EXPORT_SELECTED_TO_CLIPBOARD, (Command)new ExportToClipboardAction(this.dialogService, this.stateManager, this.clipBoardManager, this.taskExecutor, this.preferencesService)));
        objectArray2[6] = factory.createMenuItem(StandardActions.PASTE, (Command)new EditAction(StandardActions.PASTE, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        objectArray2[7] = new SeparatorMenuItem();
        objectArray2[8] = factory.createMenuItem(StandardActions.REPLACE_ALL, (Command)new ReplaceStringAction(this.frame::getCurrentLibraryTab, this.stateManager, this.dialogService));
        objectArray2[9] = factory.createMenuItem(StandardActions.GENERATE_CITE_KEYS, (Command)new GenerateCitationKeyAction(this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager, this.taskExecutor, this.preferencesService, this.undoManager));
        objectArray2[10] = new SeparatorMenuItem();
        objectArray2[11] = factory.createMenuItem(StandardActions.MANAGE_KEYWORDS, (Command)new ManageKeywordsAction(this.stateManager));
        objectArray2[12] = factory.createMenuItem(StandardActions.AUTOMATIC_FIELD_EDITOR, (Command)new AutomaticFieldEditorAction(this.stateManager, this.dialogService, this.undoManager));
        edit.getItems().addAll(objectArray2);
        SeparatorMenuItem specialFieldsSeparator = new SeparatorMenuItem();
        specialFieldsSeparator.visibleProperty().bind((ObservableValue)this.preferencesService.getSpecialFieldsPreferences().specialFieldsEnabledProperty());
        Object[] objectArray3 = new MenuItem[7];
        objectArray3[0] = specialFieldsSeparator;
        objectArray3[1] = SpecialFieldMenuItemFactory.createSpecialFieldMenu(SpecialField.RANKING, factory, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.undoManager, this.stateManager);
        objectArray3[2] = SpecialFieldMenuItemFactory.getSpecialFieldSingleItem(SpecialField.RELEVANCE, factory, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.undoManager, this.stateManager);
        objectArray3[3] = SpecialFieldMenuItemFactory.getSpecialFieldSingleItem(SpecialField.QUALITY, factory, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.undoManager, this.stateManager);
        objectArray3[4] = SpecialFieldMenuItemFactory.getSpecialFieldSingleItem(SpecialField.PRINTED, factory, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.undoManager, this.stateManager);
        objectArray3[5] = SpecialFieldMenuItemFactory.createSpecialFieldMenu(SpecialField.PRIORITY, factory, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.undoManager, this.stateManager);
        objectArray3[6] = SpecialFieldMenuItemFactory.createSpecialFieldMenu(SpecialField.READ_STATUS, factory, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.undoManager, this.stateManager);
        edit.getItems().addAll(objectArray3);
        edit.addEventHandler(ActionEvent.ACTION, event -> {
            if (OS.OS_X && !this.frame.getMainStage().focusedProperty().get()) {
                event.consume();
            }
        });
        Object[] objectArray4 = new MenuItem[5];
        objectArray4[0] = factory.createMenuItem(StandardActions.NEW_ENTRY, (Command)new NewEntryAction(this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService, this.stateManager));
        objectArray4[1] = factory.createMenuItem(StandardActions.NEW_ENTRY_FROM_PLAIN_TEXT, (Command)new ExtractBibtexAction(this.dialogService, this.preferencesService, this.stateManager));
        objectArray4[2] = factory.createMenuItem(StandardActions.DELETE_ENTRY, (Command)new EditAction(StandardActions.DELETE_ENTRY, this.frame::getCurrentLibraryTab, this.stateManager, this.undoManager));
        objectArray4[3] = new SeparatorMenuItem();
        objectArray4[4] = factory.createMenuItem(StandardActions.LIBRARY_PROPERTIES, (Command)new LibraryPropertiesAction(this.stateManager));
        library.getItems().addAll(objectArray4);
        Object[] objectArray5 = new MenuItem[9];
        objectArray5[0] = factory.createMenuItem(StandardActions.FIND_DUPLICATES, (Command)new DuplicateSearch(this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager, this.preferencesService, this.entryTypesManager, this.taskExecutor));
        objectArray5[1] = factory.createMenuItem(StandardActions.MERGE_ENTRIES, (Command)new MergeEntriesAction(this.dialogService, this.stateManager, this.undoManager, this.preferencesService));
        objectArray5[2] = factory.createMenuItem(StandardActions.CHECK_INTEGRITY, (Command)new IntegrityCheckAction(this.frame::getCurrentLibraryTab, this.preferencesService, this.dialogService, this.stateManager, this.taskExecutor, this.abbreviationRepository));
        objectArray5[3] = factory.createMenuItem(StandardActions.CLEANUP_ENTRIES, (Command)new CleanupAction(this.frame::getCurrentLibraryTab, this.preferencesService, this.dialogService, this.stateManager, this.taskExecutor, this.undoManager));
        objectArray5[4] = new SeparatorMenuItem();
        objectArray5[5] = factory.createMenuItem(StandardActions.SET_FILE_LINKS, (Command)new AutoLinkFilesAction(this.dialogService, this.preferencesService, this.stateManager, this.undoManager, this.taskExecutor));
        objectArray5[6] = new SeparatorMenuItem();
        MenuItem[] menuItemArray2 = new MenuItem[3];
        menuItemArray2[0] = factory.createMenuItem(StandardActions.ABBREVIATE_DEFAULT, (Command)new AbbreviateAction(StandardActions.ABBREVIATE_DEFAULT, this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager, this.preferencesService.getJournalAbbreviationPreferences(), this.abbreviationRepository, this.taskExecutor, this.undoManager));
        menuItemArray2[1] = factory.createMenuItem(StandardActions.ABBREVIATE_DOTLESS, (Command)new AbbreviateAction(StandardActions.ABBREVIATE_DOTLESS, this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager, this.preferencesService.getJournalAbbreviationPreferences(), this.abbreviationRepository, this.taskExecutor, this.undoManager));
        menuItemArray2[2] = factory.createMenuItem(StandardActions.ABBREVIATE_SHORTEST_UNIQUE, (Command)new AbbreviateAction(StandardActions.ABBREVIATE_SHORTEST_UNIQUE, this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager, this.preferencesService.getJournalAbbreviationPreferences(), this.abbreviationRepository, this.taskExecutor, this.undoManager));
        objectArray5[7] = factory.createSubMenu(StandardActions.ABBREVIATE, menuItemArray2);
        objectArray5[8] = factory.createMenuItem(StandardActions.UNABBREVIATE, (Command)new AbbreviateAction(StandardActions.UNABBREVIATE, this.frame::getCurrentLibraryTab, this.dialogService, this.stateManager, this.preferencesService.getJournalAbbreviationPreferences(), this.abbreviationRepository, this.taskExecutor, this.undoManager));
        quality.getItems().addAll(objectArray5);
        Menu lookupIdentifiers = factory.createSubMenu(StandardActions.LOOKUP_DOC_IDENTIFIER, new MenuItem[0]);
        for (IdFetcher idFetcher : WebFetchers.getIdFetchers(this.preferencesService.getImportFormatPreferences())) {
            LookupIdentifierAction identifierAction = new LookupIdentifierAction(idFetcher, this.stateManager, this.undoManager, this.dialogService, this.taskExecutor);
            lookupIdentifiers.getItems().add((Object)factory.createMenuItem(identifierAction.getAction(), (Command)identifierAction));
        }
        lookup.getItems().addAll((Object[])new MenuItem[]{lookupIdentifiers, factory.createMenuItem(StandardActions.DOWNLOAD_FULL_TEXT, (Command)new DownloadFullTextAction(this.dialogService, this.stateManager, this.preferencesService, this.taskExecutor)), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.FIND_UNLINKED_FILES, (Command)new FindUnlinkedFilesAction(this.dialogService, this.stateManager))});
        MenuItem pushToApplicationMenuItem = factory.createMenuItem(this.pushToApplicationCommand.getAction(), (Command)this.pushToApplicationCommand);
        this.pushToApplicationCommand.registerReconfigurable(pushToApplicationMenuItem);
        Object[] objectArray6 = new MenuItem[16];
        objectArray6[0] = factory.createMenuItem(StandardActions.PARSE_LATEX, (Command)new ParseLatexAction(this.stateManager));
        objectArray6[1] = factory.createMenuItem(StandardActions.NEW_SUB_LIBRARY_FROM_AUX, (Command)new NewSubLibraryAction(this.frame, this.stateManager, this.dialogService));
        objectArray6[2] = new SeparatorMenuItem();
        objectArray6[3] = factory.createMenuItem(StandardActions.WRITE_METADATA_TO_PDF, (Command)new WriteMetadataToLinkedPdfsAction(this.dialogService, this.preferencesService.getFieldPreferences(), this.preferencesService.getFilePreferences(), this.preferencesService.getXmpPreferences(), this.entryTypesManager, this.abbreviationRepository, this.taskExecutor, this.stateManager));
        objectArray6[4] = factory.createMenuItem(StandardActions.COPY_LINKED_FILES, (Command)new CopyFilesAction(this.dialogService, this.preferencesService, this.stateManager, this.taskExecutor));
        objectArray6[5] = new SeparatorMenuItem();
        objectArray6[6] = this.createSendSubMenu(factory, this.dialogService, this.stateManager, this.preferencesService);
        objectArray6[7] = pushToApplicationMenuItem;
        objectArray6[8] = new SeparatorMenuItem();
        objectArray6[9] = factory.createMenuItem(StandardActions.START_NEW_STUDY, (Command)new StartNewStudyAction((LibraryTabContainer)this.frame, this.openDatabaseActionSupplier, this.fileUpdateMonitor, this.taskExecutor, this.preferencesService, this.stateManager, this.dialogService));
        objectArray6[10] = factory.createMenuItem(StandardActions.EDIT_EXISTING_STUDY, (Command)new EditExistingStudyAction(this.dialogService, this.stateManager));
        objectArray6[11] = factory.createMenuItem(StandardActions.UPDATE_SEARCH_RESULTS_OF_STUDY, (Command)new ExistingStudySearchAction(this.frame, this.openDatabaseActionSupplier, this.dialogService, this.fileUpdateMonitor, this.taskExecutor, this.preferencesService, this.stateManager));
        objectArray6[12] = new SeparatorMenuItem();
        objectArray6[13] = factory.createMenuItem(StandardActions.REBUILD_FULLTEXT_SEARCH_INDEX, (Command)new RebuildFulltextSearchIndexAction(this.stateManager, this.frame::getCurrentLibraryTab, this.dialogService, this.preferencesService.getFilePreferences(), this.taskExecutor));
        objectArray6[14] = new SeparatorMenuItem();
        objectArray6[15] = factory.createMenuItem(StandardActions.REDOWNLOAD_MISSING_FILES, (Command)new RedownloadMissingFilesAction(this.stateManager, this.dialogService, this.preferencesService.getFilePreferences(), this.taskExecutor));
        tools.getItems().addAll(objectArray6);
        SidePaneType sidePaneType = SidePaneType.WEB_SEARCH;
        SidePaneType groupsPane = SidePaneType.GROUPS;
        SidePaneType openOfficePane = SidePaneType.OPEN_OFFICE;
        Object[] objectArray7 = new MenuItem[10];
        objectArray7[0] = factory.createCheckMenuItem(sidePaneType.getToggleAction(), (Command)this.sidePane.getToggleCommandFor(sidePaneType), (BooleanExpression)this.sidePane.paneVisibleBinding(sidePaneType));
        objectArray7[1] = factory.createCheckMenuItem(groupsPane.getToggleAction(), (Command)this.sidePane.getToggleCommandFor(groupsPane), (BooleanExpression)this.sidePane.paneVisibleBinding(groupsPane));
        objectArray7[2] = factory.createCheckMenuItem(openOfficePane.getToggleAction(), (Command)this.sidePane.getToggleCommandFor(openOfficePane), (BooleanExpression)this.sidePane.paneVisibleBinding(openOfficePane));
        objectArray7[3] = new SeparatorMenuItem();
        objectArray7[4] = factory.createMenuItem(StandardActions.NEXT_PREVIEW_STYLE, (Command)new PreviewSwitchAction(PreviewSwitchAction.Direction.NEXT, this.frame::getCurrentLibraryTab, this.stateManager));
        objectArray7[5] = factory.createMenuItem(StandardActions.PREVIOUS_PREVIEW_STYLE, (Command)new PreviewSwitchAction(PreviewSwitchAction.Direction.PREVIOUS, this.frame::getCurrentLibraryTab, this.stateManager));
        objectArray7[6] = new SeparatorMenuItem();
        objectArray7[7] = factory.createMenuItem(StandardActions.SHOW_PDF_VIEWER, (Command)new ShowDocumentViewerAction(this.stateManager, this.preferencesService));
        objectArray7[8] = factory.createMenuItem(StandardActions.EDIT_ENTRY, (Command)new OpenEntryEditorAction(this.frame::getCurrentLibraryTab, this.stateManager));
        objectArray7[9] = factory.createMenuItem(StandardActions.OPEN_CONSOLE, (Command)new OpenConsoleAction(this.stateManager, this.preferencesService, this.dialogService));
        view.getItems().addAll(objectArray7);
        help.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.HELP, (Command)new HelpAction(HelpFile.CONTENTS, this.dialogService, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.OPEN_FORUM, (Command)new OpenBrowserAction("http://discourse.jabref.org/", this.dialogService, this.preferencesService.getFilePreferences())), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.ERROR_CONSOLE, (Command)new ErrorConsoleAction()), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.DONATE, (Command)new OpenBrowserAction("https://donations.jabref.org", this.dialogService, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.SEARCH_FOR_UPDATES, (Command)new SearchForUpdateAction(this.preferencesService, this.dialogService, this.taskExecutor)), factory.createSubMenu(StandardActions.WEB_MENU, new MenuItem[]{factory.createMenuItem(StandardActions.OPEN_WEBPAGE, (Command)new OpenBrowserAction("https://jabref.org/", this.dialogService, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.OPEN_BLOG, (Command)new OpenBrowserAction("https://blog.jabref.org/", this.dialogService, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.OPEN_FACEBOOK, (Command)new OpenBrowserAction("https://www.facebook.com/JabRef/", this.dialogService, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.OPEN_TWITTER, (Command)new OpenBrowserAction("https://twitter.com/jabref_org", this.dialogService, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.OPEN_GITHUB, (Command)new OpenBrowserAction("https://github.com/JabRef/jabref", this.dialogService, this.preferencesService.getFilePreferences())), new SeparatorMenuItem(), factory.createMenuItem(StandardActions.OPEN_DEV_VERSION_LINK, (Command)new OpenBrowserAction("https://builds.jabref.org/master/", this.dialogService, this.preferencesService.getFilePreferences())), factory.createMenuItem(StandardActions.OPEN_CHANGELOG, (Command)new OpenBrowserAction("https://github.com/JabRef/jabref/blob/main/CHANGELOG.md", this.dialogService, this.preferencesService.getFilePreferences()))}), factory.createMenuItem(StandardActions.ABOUT, (Command)new AboutAction())});
        this.getStyleClass().add((Object)"mainMenu");
        this.getMenus().addAll((Object[])new Menu[]{file, edit, library, quality, lookup, tools, view, help});
        this.setUseSystemMenuBar(true);
    }

    private Menu createSendSubMenu(ActionFactory factory, DialogService dialogService, StateManager stateManager, PreferencesService preferencesService) {
        Menu sendMenu = factory.createMenu(StandardActions.SEND);
        sendMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.SEND_AS_EMAIL, (Command)new SendAsStandardEmailAction(dialogService, preferencesService, stateManager, this.entryTypesManager, this.taskExecutor)), factory.createMenuItem(StandardActions.SEND_TO_KINDLE, (Command)new SendAsKindleEmailAction(dialogService, preferencesService, stateManager, this.taskExecutor))});
        return sendMenu;
    }
}

