/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import java.io.IOException;
import java.io.StringWriter;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.frame.SendAsEMailAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.FieldWriter;
import org.jabref.logic.exporter.BibWriter;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAsStandardEmailAction
extends SendAsEMailAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendAsStandardEmailAction.class);
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final BibEntryTypesManager entryTypesManager;

    public SendAsStandardEmailAction(DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor) {
        super(dialogService, preferencesService, stateManager, taskExecutor);
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.entryTypesManager = entryTypesManager;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    @Override
    protected String getEmailAddress() {
        return "";
    }

    @Override
    protected String getSubject() {
        return this.preferencesService.getExternalApplicationsPreferences().getEmailSubject();
    }

    @Override
    protected String getBody() {
        ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
        BibDatabaseContext databaseContext = this.stateManager.getActiveDatabase().get();
        StringWriter rawEntries = new StringWriter();
        BibWriter bibWriter = new BibWriter(rawEntries, OS.NEWLINE);
        BibEntryWriter bibtexEntryWriter = new BibEntryWriter(new FieldWriter(this.preferencesService.getFieldPreferences()), this.entryTypesManager);
        for (BibEntry entry : entries) {
            try {
                bibtexEntryWriter.write(entry, bibWriter, databaseContext.getMode());
            }
            catch (IOException e) {
                LOGGER.warn("Problem creating BibTeX file for mailing.", (Throwable)e);
            }
        }
        return rawEntries.toString();
    }
}

