/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import com.airhacks.afterburner.views.ViewLoader;
import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.groups.GroupColorPicker;
import org.jabref.gui.groups.GroupDialogHeader;
import org.jabref.gui.groups.GroupDialogViewModel;
import org.jabref.gui.help.HelpAction;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabrefIconProvider;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;
import org.jspecify.annotations.Nullable;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonProvider;
import org.kordamp.ikonli.javafx.FontIcon;

public class GroupDialogView
extends BaseDialog<AbstractGroup> {
    private static boolean useAutoColoring = false;
    @FXML
    private TextField nameField;
    @FXML
    private TextField descriptionField;
    @FXML
    private TextField iconField;
    @FXML
    private Button iconPickerButton;
    @FXML
    private CheckBox colorUseCheckbox;
    @FXML
    private ColorPicker colorField;
    @FXML
    private ComboBox<GroupHierarchyType> hierarchicalContextCombo;
    @FXML
    private CheckBox autoColorCheckbox;
    @FXML
    private RadioButton explicitRadioButton;
    @FXML
    private RadioButton keywordsRadioButton;
    @FXML
    private RadioButton searchRadioButton;
    @FXML
    private RadioButton autoRadioButton;
    @FXML
    private RadioButton texRadioButton;
    @FXML
    private TextField keywordGroupSearchTerm;
    @FXML
    private TextField keywordGroupSearchField;
    @FXML
    private CheckBox keywordGroupCaseSensitive;
    @FXML
    private CheckBox keywordGroupRegex;
    @FXML
    private TextField searchGroupSearchTerm;
    @FXML
    private CheckBox searchGroupCaseSensitive;
    @FXML
    private CheckBox searchGroupRegex;
    @FXML
    private RadioButton autoGroupKeywordsOption;
    @FXML
    private TextField autoGroupKeywordsField;
    @FXML
    private TextField autoGroupKeywordsDeliminator;
    @FXML
    private TextField autoGroupKeywordsHierarchicalDeliminator;
    @FXML
    private RadioButton autoGroupPersonsOption;
    @FXML
    private TextField autoGroupPersonsField;
    @FXML
    private TextField texGroupFilePath;
    private final EnumMap<GroupHierarchyType, String> hierarchyText = new EnumMap(GroupHierarchyType.class);
    private final EnumMap<GroupHierarchyType, String> hierarchyToolTip = new EnumMap(GroupHierarchyType.class);
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();
    private final BibDatabaseContext currentDatabase;
    private final @Nullable GroupTreeNode parentNode;
    private final @Nullable AbstractGroup editedGroup;
    private GroupDialogViewModel viewModel;
    @Inject
    private FileUpdateMonitor fileUpdateMonitor;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;

    public GroupDialogView(BibDatabaseContext currentDatabase, @Nullable GroupTreeNode parentNode, @Nullable AbstractGroup editedGroup, GroupDialogHeader groupDialogHeader) {
        this.currentDatabase = currentDatabase;
        this.parentNode = parentNode;
        this.editedGroup = editedGroup;
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        if (editedGroup == null) {
            if (groupDialogHeader == GroupDialogHeader.GROUP) {
                this.setTitle(Localization.lang("Add group", new Object[0]));
            } else if (groupDialogHeader == GroupDialogHeader.SUBGROUP) {
                this.setTitle(Localization.lang("Add subgroup", new Object[0]));
            }
        } else {
            this.setTitle(Localization.lang("Edit group", new Object[0]) + " " + editedGroup.getName());
        }
        ButtonType helpButtonType = new ButtonType("", ButtonBar.ButtonData.HELP_2);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{helpButtonType, ButtonType.OK, ButtonType.CANCEL});
        Button confirmDialogButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        Button helpButton = (Button)this.getDialogPane().lookupButton(helpButtonType);
        ActionFactory actionFactory = new ActionFactory();
        HelpAction helpAction = new HelpAction(HelpFile.GROUPS, this.dialogService, this.preferencesService.getFilePreferences());
        actionFactory.configureIconButton(StandardActions.HELP_GROUPS, (Command)helpAction, (ButtonBase)helpButton);
        helpButton.addEventFilter(ActionEvent.ACTION, event -> {
            helpAction.execute();
            event.consume();
        });
        confirmDialogButton.disableProperty().bind((ObservableValue)this.viewModel.validationStatus().validProperty().not());
        confirmDialogButton.addEventFilter(ActionEvent.ACTION, this.viewModel::validationHandler);
    }

    private @Nullable AbstractGroup parentGroup() {
        if (this.parentNode == null) {
            return null;
        }
        return this.parentNode.getGroup();
    }

    @FXML
    public void initialize() {
        this.viewModel = new GroupDialogViewModel(this.dialogService, this.currentDatabase, this.preferencesService, this.editedGroup, this.parentNode, this.fileUpdateMonitor);
        this.setResultConverter(this.viewModel::resultConverter);
        this.hierarchyText.put(GroupHierarchyType.INCLUDING, Localization.lang("Union", new Object[0]));
        this.hierarchyToolTip.put(GroupHierarchyType.INCLUDING, Localization.lang("Include subgroups: When selected, view entries contained in this group or its subgroups", new Object[0]));
        this.hierarchyText.put(GroupHierarchyType.REFINING, Localization.lang("Intersection", new Object[0]));
        this.hierarchyToolTip.put(GroupHierarchyType.REFINING, Localization.lang("Refine supergroup: When selected, view entries contained in both this group and its supergroup", new Object[0]));
        this.hierarchyText.put(GroupHierarchyType.INDEPENDENT, Localization.lang("Independent", new Object[0]));
        this.hierarchyToolTip.put(GroupHierarchyType.INDEPENDENT, Localization.lang("Independent group: When selected, view only this group's entries", new Object[0]));
        this.nameField.textProperty().bindBidirectional((Property)this.viewModel.nameProperty());
        this.descriptionField.textProperty().bindBidirectional((Property)this.viewModel.descriptionProperty());
        this.iconField.textProperty().bindBidirectional((Property)this.viewModel.iconProperty());
        this.colorUseCheckbox.selectedProperty().bindBidirectional((Property)this.viewModel.colorUseProperty());
        this.colorField.valueProperty().bindBidirectional(this.viewModel.colorFieldProperty());
        this.hierarchicalContextCombo.itemsProperty().bind(this.viewModel.groupHierarchyListProperty());
        new ViewModelListCellFactory().withText(this.hierarchyText::get).withStringTooltip(this.hierarchyToolTip::get).install(this.hierarchicalContextCombo);
        this.hierarchicalContextCombo.valueProperty().bindBidirectional(this.viewModel.groupHierarchySelectedProperty());
        this.explicitRadioButton.selectedProperty().bindBidirectional((Property)this.viewModel.typeExplicitProperty());
        this.keywordsRadioButton.selectedProperty().bindBidirectional((Property)this.viewModel.typeKeywordsProperty());
        this.searchRadioButton.selectedProperty().bindBidirectional((Property)this.viewModel.typeSearchProperty());
        this.autoRadioButton.selectedProperty().bindBidirectional((Property)this.viewModel.typeAutoProperty());
        this.texRadioButton.selectedProperty().bindBidirectional((Property)this.viewModel.typeTexProperty());
        this.keywordGroupSearchTerm.textProperty().bindBidirectional((Property)this.viewModel.keywordGroupSearchTermProperty());
        this.keywordGroupSearchField.textProperty().bindBidirectional((Property)this.viewModel.keywordGroupSearchFieldProperty());
        this.keywordGroupCaseSensitive.selectedProperty().bindBidirectional((Property)this.viewModel.keywordGroupCaseSensitiveProperty());
        this.keywordGroupRegex.selectedProperty().bindBidirectional((Property)this.viewModel.keywordGroupRegexProperty());
        this.searchGroupSearchTerm.textProperty().bindBidirectional((Property)this.viewModel.searchGroupSearchTermProperty());
        this.searchGroupCaseSensitive.setSelected(((EnumSet)this.viewModel.searchFlagsProperty().getValue()).contains((Object)SearchRules.SearchFlags.CASE_SENSITIVE));
        this.searchGroupCaseSensitive.selectedProperty().addListener((observable, oldValue, newValue) -> {
            EnumSet searchFlags = (EnumSet)this.viewModel.searchFlagsProperty().get();
            if (newValue.booleanValue()) {
                searchFlags.add(SearchRules.SearchFlags.CASE_SENSITIVE);
            } else {
                searchFlags.remove((Object)SearchRules.SearchFlags.CASE_SENSITIVE);
            }
            this.viewModel.searchFlagsProperty().set((Object)searchFlags);
        });
        this.searchGroupRegex.setSelected(((EnumSet)this.viewModel.searchFlagsProperty().getValue()).contains((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION));
        this.searchGroupRegex.selectedProperty().addListener((observable, oldValue, newValue) -> {
            EnumSet searchFlags = (EnumSet)this.viewModel.searchFlagsProperty().get();
            if (newValue.booleanValue()) {
                searchFlags.add(SearchRules.SearchFlags.REGULAR_EXPRESSION);
            } else {
                searchFlags.remove((Object)SearchRules.SearchFlags.REGULAR_EXPRESSION);
            }
            this.viewModel.searchFlagsProperty().set((Object)searchFlags);
        });
        this.autoGroupKeywordsOption.selectedProperty().bindBidirectional((Property)this.viewModel.autoGroupKeywordsOptionProperty());
        this.autoGroupKeywordsField.textProperty().bindBidirectional((Property)this.viewModel.autoGroupKeywordsFieldProperty());
        this.autoGroupKeywordsDeliminator.textProperty().bindBidirectional((Property)this.viewModel.autoGroupKeywordsDeliminatorProperty());
        this.autoGroupKeywordsHierarchicalDeliminator.textProperty().bindBidirectional((Property)this.viewModel.autoGroupKeywordsHierarchicalDeliminatorProperty());
        this.autoGroupPersonsOption.selectedProperty().bindBidirectional((Property)this.viewModel.autoGroupPersonsOptionProperty());
        this.autoGroupPersonsField.textProperty().bindBidirectional((Property)this.viewModel.autoGroupPersonsFieldProperty());
        this.texGroupFilePath.textProperty().bindBidirectional((Property)this.viewModel.texGroupFilePathProperty());
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        Platform.runLater(() -> {
            this.validationVisualizer.initVisualization(this.viewModel.nameValidationStatus(), (Control)this.nameField);
            this.validationVisualizer.initVisualization(this.viewModel.nameContainsDelimiterValidationStatus(), (Control)this.nameField, false);
            this.validationVisualizer.initVisualization(this.viewModel.sameNameValidationStatus(), (Control)this.nameField);
            this.validationVisualizer.initVisualization(this.viewModel.searchRegexValidationStatus(), (Control)this.searchGroupSearchTerm);
            this.validationVisualizer.initVisualization(this.viewModel.searchSearchTermEmptyValidationStatus(), (Control)this.searchGroupSearchTerm);
            this.validationVisualizer.initVisualization(this.viewModel.keywordRegexValidationStatus(), (Control)this.keywordGroupSearchTerm);
            this.validationVisualizer.initVisualization(this.viewModel.keywordSearchTermEmptyValidationStatus(), (Control)this.keywordGroupSearchTerm);
            this.validationVisualizer.initVisualization(this.viewModel.keywordFieldEmptyValidationStatus(), (Control)this.keywordGroupSearchField);
            this.validationVisualizer.initVisualization(this.viewModel.texGroupFilePathValidatonStatus(), (Control)this.texGroupFilePath);
            this.nameField.requestFocus();
        });
        this.autoColorCheckbox.setSelected(useAutoColoring);
        this.autoColorCheckbox.setOnAction(event -> {
            useAutoColoring = this.autoColorCheckbox.isSelected();
            if (!this.autoColorCheckbox.isSelected()) {
                return;
            }
            if (this.parentNode == null) {
                this.viewModel.colorFieldProperty().setValue((Object)IconTheme.getDefaultGroupColor());
                return;
            }
            List colorsOfSiblings = this.parentNode.getChildren().stream().map(child -> child.getGroup().getColor()).flatMap(Optional::stream).toList();
            Optional<Color> parentColor = this.parentGroup().getColor();
            Color color = parentColor.map(value -> GroupColorPicker.generateColor(colorsOfSiblings, value)).orElseGet(() -> GroupColorPicker.generateColor(colorsOfSiblings));
            this.viewModel.colorFieldProperty().setValue((Object)color);
        });
    }

    @FXML
    private void texGroupBrowse() {
        this.viewModel.texGroupBrowse();
    }

    @FXML
    private void openIconPicker() {
        ObservableList ikonList = FXCollections.observableArrayList();
        FilteredList filteredList = new FilteredList(ikonList);
        for (IkonProvider provider : ServiceLoader.load(IkonProvider.class.getModule().getLayer(), IkonProvider.class)) {
            if (provider.getClass() == JabrefIconProvider.class) continue;
            ikonList.addAll(EnumSet.allOf(provider.getIkon()));
        }
        CustomTextField searchBox = new CustomTextField();
        searchBox.setPromptText(Localization.lang("Search", new Object[0]) + "...");
        searchBox.setLeft(IconTheme.JabRefIcons.SEARCH.getGraphicNode());
        searchBox.textProperty().addListener((obs, oldValue, newValue) -> filteredList.setPredicate(ikon -> newValue.isEmpty() || ikon.getDescription().toLowerCase().contains(newValue.toLowerCase())));
        GridView ikonGridView = new GridView(FXCollections.observableArrayList());
        ikonGridView.setCellFactory(gridView -> new IkonliCell());
        ikonGridView.setPrefWidth(520.0);
        ikonGridView.setPrefHeight(400.0);
        ikonGridView.setHorizontalCellSpacing(4.0);
        ikonGridView.setVerticalCellSpacing(4.0);
        VBox vBox = new VBox(10.0, new Node[]{searchBox, ikonGridView});
        vBox.setPadding(new Insets(10.0));
        Platform.runLater(() -> ikonGridView.setItems((ObservableList)filteredList));
        PopOver popOver = new PopOver((Node)vBox);
        popOver.setDetachable(false);
        popOver.setArrowSize(0.0);
        popOver.setCornerRadius(0.0);
        popOver.setTitle("Icon picker");
        popOver.show((Node)this.iconPickerButton);
    }

    public class IkonliCell
    extends GridCell<Ikon> {
        protected void updateItem(Ikon ikon, boolean empty) {
            super.updateItem((Object)ikon, empty);
            if (empty || ikon == null) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                FontIcon fontIcon = FontIcon.of((Ikon)ikon);
                fontIcon.getStyleClass().setAll((Object[])new String[]{"font-icon"});
                fontIcon.setIconSize(22);
                this.setGraphic((Node)fontIcon);
                this.setAlignment(Pos.BASELINE_CENTER);
                this.setPadding(new Insets(1.0));
                this.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.THIN)}));
                this.setOnMouseClicked(event -> {
                    GroupDialogView.this.iconField.textProperty().setValue(String.valueOf(fontIcon.getIconCode()));
                    PopOver stage = (PopOver)this.getGridView().getParent().getScene().getWindow();
                    stage.hide();
                });
            }
        }
    }
}

