/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.help;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.util.BaseDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.Version;
import org.jabref.preferences.FilePreferences;

public class NewVersionDialog
extends BaseDialog<Boolean> {
    public NewVersionDialog(Version currentVersion, Version latestVersion, DialogService dialogService, FilePreferences filePreferences) {
        this.setTitle(Localization.lang("New version available", new Object[0]));
        ButtonType btnIgnoreUpdate = new ButtonType(Localization.lang("Ignore this update", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType btnDownloadUpdate = new ButtonType(Localization.lang("Download update", new Object[0]), ButtonBar.ButtonData.APPLY);
        ButtonType btnRemindMeLater = new ButtonType(Localization.lang("Remind me later", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{btnIgnoreUpdate, btnDownloadUpdate, btnRemindMeLater});
        this.setResultConverter(button -> {
            if (button == btnIgnoreUpdate) {
                return false;
            }
            if (button == btnDownloadUpdate) {
                JabRefDesktop.openBrowserShowPopup("https://downloads.jabref.org", dialogService, filePreferences);
            }
            return true;
        });
        Button defaultButton = (Button)this.getDialogPane().lookupButton(btnDownloadUpdate);
        defaultButton.setDefaultButton(true);
        Hyperlink lblMoreInformation = new Hyperlink(Localization.lang("To see what is new view the changelog.", new Object[0]));
        lblMoreInformation.setOnAction(event -> JabRefDesktop.openBrowserShowPopup(latestVersion.getChangelogUrl(), dialogService, filePreferences));
        VBox container = new VBox(new Node[]{new Label(Localization.lang("A new version of JabRef has been released.", new Object[0])), new Label(Localization.lang("Installed version", new Object[0]) + ": " + currentVersion.getFullVersion()), new Label(Localization.lang("Latest version", new Object[0]) + ": " + latestVersion.getFullVersion()), lblMoreInformation});
        this.getDialogPane().setContent((Node)container);
        this.getDialogPane().setPrefWidth(450.0);
    }
}

