/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.actions;

import com.airhacks.afterburner.injection.Injector;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.gui.DialogService;
import org.jabref.gui.importer.ImportCustomEntryTypesDialog;
import org.jabref.gui.importer.actions.GUIPostOpenAction;
import org.jabref.logic.importer.ParserResult;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.LibraryPreferences;
import org.jabref.preferences.PreferencesService;

public class CheckForNewEntryTypesAction
implements GUIPostOpenAction {
    @Override
    public boolean isActionNecessary(ParserResult parserResult, PreferencesService preferencesService) {
        return !this.getListOfUnknownAndUnequalCustomizations(parserResult, preferencesService.getLibraryPreferences()).isEmpty();
    }

    @Override
    public void performAction(ParserResult parserResult, DialogService dialogService, PreferencesService preferencesService) {
        LibraryPreferences preferences = preferencesService.getLibraryPreferences();
        BibDatabaseMode mode = this.getBibDatabaseModeFromParserResult(parserResult, preferences);
        dialogService.showCustomDialogAndWait(new ImportCustomEntryTypesDialog(mode, this.getListOfUnknownAndUnequalCustomizations(parserResult, preferences)));
    }

    private List<BibEntryType> getListOfUnknownAndUnequalCustomizations(ParserResult parserResult, LibraryPreferences preferences) {
        BibDatabaseMode mode = this.getBibDatabaseModeFromParserResult(parserResult, preferences);
        BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        return parserResult.getEntryTypes().stream().filter(type -> entryTypesManager.isDifferentCustomOrModifiedType((BibEntryType)type, mode)).collect(Collectors.toList());
    }

    private BibDatabaseMode getBibDatabaseModeFromParserResult(ParserResult parserResult, LibraryPreferences preferences) {
        return parserResult.getMetaData().getMode().orElse(preferences.getDefaultBibDatabaseMode());
    }
}

